/*

    File: file_zip.c

    Copyright (C) 1998-2006 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 51
    Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <stdio.h>
#include "types.h"
#include "photorec.h"

static const char* header_check_zip(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery);
static void file_check_zip(t_file_recovery *file_recovery);


const t_file_hint file_hint_zip= {
  .extension="zip",
  .description="zip archive",
  .min_header_distance=0,
  .min_filesize=21,
  .max_filesize=PHOTOREC_MAX_FILE_SIZE,
  .recover=1,
  .header_check=&header_check_zip,
  .data_check=NULL,
  .file_check=&file_check_zip
};

static const char* header_check_zip(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery)
{
  const unsigned char zip_header[4]  = { 'P', 'K', 0x03, 0x04};
  const unsigned char zip_header2[8]  = { 'P', 'K', '0', '0', 'P', 'K', 0x03, 0x04}; /* WinZIPv8-compressed files. */
  if(memcmp(buffer,zip_header,sizeof(zip_header))==0)
  {
     if(memcmp(&buffer[30],"mimetypeapplication/vnd.sun.xml.",32)==0)
     {
       if(memcmp(&buffer[62],"calc",4)==0)
       {
	 return "sxc";
       }
       else if(memcmp(&buffer[62],"draw",4)==0)
       {
	 return "sxd";
       }
       else if(memcmp(&buffer[62],"impress",7)==0)
       {
	 return "sxi";
       }
       else if(memcmp(&buffer[62],"writer",6)==0)
       {
	 return "sxw";
       }
       else
       { /* default to writer */
	 return "sxw";
       }
     }
     else if(memcmp(&buffer[30],"mimetypeapplication/vnd.oasis.opendocument.graphics",51)==0)
       return "odg";
     else if(memcmp(&buffer[30],"mimetypeapplication/vnd.oasis.opendocument.presentation",55)==0)
       return "odp";
     else if(memcmp(&buffer[30],"mimetypeapplication/vnd.oasis.opendocument.spreadsheet",54)==0)
       return "ods";
     else if(memcmp(&buffer[30],"mimetypeapplication/vnd.oasis.opendocument.text",47)==0)
       return "odt";
    return file_hint_zip.extension;
  }
  if(memcmp(buffer,zip_header2,sizeof(zip_header2))==0)
    return file_hint_zip.extension;
  return NULL;
}

static void file_check_zip(t_file_recovery *file_recovery)
{
  const unsigned char zip_footer[4]= {0x4b, 0x05, 0x06, 0x00};
  file_search_footer(file_recovery, zip_footer,sizeof(zip_footer));
  if(file_recovery->file_size>0)
    file_recovery->file_size+=17;
}
