/* rgb.c
 */
/*
 * Copyright (C) 2001  Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#ifdef HAVE_STDARG_H
#  include <stdarg.h>
#else
#  include <vararg.h>
#endif
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#if defined(HAVE_STRING_H)
#  include  <string.h>
#endif
#if defined(HAVE_STRINGS_H)
#  include  <strings.h>
#endif
#include "dvi-2_6.h"
#include "defs.h"



#undef DEBUG  



struct s_color_info_rgb {
  char          *name;
  unsigned char r, g, b;
};

struct s_color_info_rgb   color_rgb[] = {
#include "rgb.h"
  { NULL, 0, 0, 0 }
};

static int  ncolors = -1;


static void rgb_count_ncolors(void);
static int  rgb_strcmp_ci(char *s, char *t);



Public int
DVI_rgb_lookup(char *name, 
	       unsigned char *rp, 
	       unsigned char *gp, 
	       unsigned char *bp)
{
#if 1
  int  hi, lo, md, v, c;

  if (ncolors < 0)
    rgb_count_ncolors();

  c = 0;
  lo = 0; 
  hi = ncolors-1;
  
  v = -1;
  while (lo <= hi){
    md = (hi + lo) / 2;
    c++;
    v = rgb_strcmp_ci(name, color_rgb[md].name);
    if (v == 0){
      *rp = color_rgb[md].r;
      *gp = color_rgb[md].g;
      *bp = color_rgb[md].b;
      break;
    } else if (v > 0){  /* name > color_rgb[md].name */
      lo = md+1;
    } else {            /* name < color_rgb[md].name */
      hi = md-1;
    }
  }
#if 0
  printf(" bin search: %d/%d\n", c, ncolors);
#endif

  return (v == 0) ? 0 : -1;

#else
  int   i;

  while (color_rgb[i].name != NULL){
    if (rgb_strcmp_ci(name, color_rgb[i].name) == 0){
      *rp = color_rgb[i].r;
      *gp = color_rgb[i].g;
      *bp = color_rgb[i].b;
      return 0;
    }
    i++;
  }
  return -1;
#endif
}


static void
rgb_count_ncolors(void)
{
  ncolors = 0;
  while (color_rgb[ncolors].name != NULL){
    ncolors++;
  }
}

static int
rgb_strcmp_ci(char *s, char *t)
{
  while (*s && *t){
    if (tolower(*s) != tolower(*t))
      break;
    s++;
    t++;
  }
  return (tolower(*s) - tolower(*t));
}


#ifdef DEBUG 
int 
main(int argc, char **argv)
{
  unsigned char  r, g, b;
  int   v;

  argc--; argv++;
  while (argc > 0){
    v = DVI_rgb_lookup(*argv, &r, &g, &b);
    if (v >= 0){
      printf("%s 0x%02x 0x%02x 0x%02x\n", *argv, (int)r, (int)g, (int)b);
    } else {
      printf("%s ???\n", *argv);
    }
    argc--; argv++;
  }
  return 0;
}
#endif

/*EOF*/
