/*
 * spc_ps.h
 * by Hirotsugu Kakugawa
 *
 *  2 May 1997  
 *
 */
/*
 * Copyright (C) 1996-1999  Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This file is part of the DVIlib Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef  __DVILIB_SPC_PS_H__
#define  __DVILIB_SPC_PS_H__


#define EPS_SIZE_SPEC_VH_SCALE       0
#define EPS_SIZE_SPEC_VH_SIZE        1
#define EPS_SIZE_SPEC_BBX            2
#define EPS_SIZE_SPEC_WIDTH_HEIGHT   3

struct ps {
  int     output_format;
  /** filled from special DVI command **/
  /* "epsfile=filename vscale=v hscale=h ..." */
  /* "postscriptbox{width}{height}{filename}" */
  char    param_filename[1024];
  int     given_filename;
  double  param_vscale, param_hscale, param_hsize, param_vsize;
  int     given_vscale, given_hscale, given_hsize, given_vsize;
  double  param_hoffset, param_voffset;
  int     given_hoffset, given_voffset;
  double  param_llx, param_lly, param_urx, param_ury, param_rwi, param_rhi;
  int     given_llx, given_lly, given_urx, given_ury, given_rwi, given_rhi;
  int     param_clip;
  int     given_clip;
  /** filled from PS file (BoundingBox info) **/
  double  ps_llx, ps_lly, ps_urx, ps_ury;
  /** Bitmap offset **/
  long          bitmap_hoffset, bitmap_voffset;
  /** filled by ps interpreter (ghostscript) **/
  int           bm_format;
  long          bm_width, bm_height;
  int           bm_rast;
  struct dvi_s_bitmap        bm;
  struct dvi_s_pixmap_rgb    bm_rgb;
  struct dvi_s_graymap       bm_gray;
};


Public int  dvi_special_postscriptbox(DVI,DVI_DEVICE,char*,long,long);
Public int  dvi_special_epsfile(DVI,DVI_DEVICE,char*,long,long);
Public int  dvi_special_PSfile(DVI,DVI_DEVICE,char*,long,long);
Public int  dvi_special_ps(DVI,DVI_DEVICE,char*,long,long);
Public int  dvi_special_invoke_gs(DVI,DVI_DEVICE);

#endif /*__DVILIB_SPC_PS_H__*/

/*EOF*/
