#!/bin/sh

# Check if we have OpenWindow.
# print "1" if we have no OpenWindow
# print "0" if we have OpenWindow

NO_OPENWIN=1

if test \( -d /usr/openwin \) -a \( -d /usr/dt/lib \); then 
  NO_OPENWIN=0
  # If OPENWINHOME is not set, we do not use OpenWindow
  if test X-${OPENWINHOME+set} != X-set; then  
    NO_OPENWIN=1
  fi
fi

# In case we have OpenWindow but an "xmkmf" to be executed is not 
# an OpenWindow's "xmkmf", we do not use OpenWindow. 
if test ${NO_OPENWIN} = 0; then 
  if test X-`../whereisit xmkmf` != X-${OPENWINHOME}/bin/xmkmf; then
    NO_OPENWIN=1
  fi
fi

echo ${NO_OPENWIN}

