/*
 * ui-cmd.c - a module for main UI panel
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_STDARG_H
#  include <stdarg.h>
#else
#  include <vararg.h>
#endif
#include <sys/types.h>
#include <sys/param.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/Xresource.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include <Xm/Scale.h>
#include <Xm/Separator.h>

#include "cf-xmdvi.h"
#include "dvi-2_6.h"
#include "dev.h"
#include "defs.h"
#include "resource.h"
#include "paper.h"
#include "window.h"
#include "ui.h"
#include "../X11/x11-defs.h"

Private Widget  x_w_message;
Private Widget  x_page_jump_slider;
Private Widget  x_page_panel;

Private Widget  x_make_panel_main(Widget);
Private Widget  x_mpm_title(Widget);
Private Widget  x_mpm_cmd(Widget);
Private Widget  x_mpm_page(Widget);
Private Widget  x_mpm_message(Widget); 

Private void  cb_page_next(Widget,caddr_t,caddr_t);
Private void  cb_page_prev(Widget,caddr_t,caddr_t);
Private void  cb_page_jump(Widget,caddr_t,caddr_t);


Public int
x_make_panel(Widget x_toplevel)
{
  Widget  x_panel_main;
  XEvent  xevent;

  x_panel_main  = x_make_panel_main(x_toplevel);
  x_make_panel_file(x_panel_main);
  x_make_panel_paper(x_panel_main);
  x_make_panel_mag(x_panel_main);
  x_make_panel_option(x_panel_main);
  x_make_panel_print(x_panel_main);
  x_make_panel_quit(x_panel_main);

  XtRealizeWidget(x_toplevel);
  XtMapWidget(x_panel_main);

  XFlush(XtDisplay(x_panel_main));
  while (XtPending()){
    XtNextEvent(&xevent);
    XtDispatchEvent(&xevent);
  }
  XSync(XtDisplay(x_panel_main), False);
  return 0;
}


Private Widget
x_make_panel_main(Widget xshell)
{
  Widget  xpanel;
  Widget  xtitle, xsep1, xcmd, xsep2, xpag, xsep3, xmsg;
  Arg     args[5];
  int     i;

  i = 0;
  XtSetArg(args[i], XmNmappedWhenManaged, True); i++;
  XtSetArg(args[i], XmNtraversalOn, False); i++;
  xpanel = XmCreateForm(xshell, "commandPanel", args, i);
  XtManageChild(xpanel);

  xtitle = x_mpm_title(xpanel);
  xsep1  = x_p_make_hsep(xpanel);
  xcmd   = x_mpm_cmd(xpanel);
  xsep2  = x_p_make_hsep(xpanel);
  xpag   = x_mpm_page(xpanel);
  xsep3  = x_p_make_hsep(xpanel);
  xmsg   = x_mpm_message(xpanel); 

  x_p_put_top(xtitle);
  x_p_put_below(xsep1, xtitle);
  x_p_put_below(xcmd,  xsep1);
  x_p_put_below(xsep2, xcmd);
  x_p_put_below(xpag,  xsep2);
  x_p_put_below(xsep3, xpag);
  x_p_put_below(xmsg,  xsep3);

  return xpanel;
}

Private Widget
x_mpm_title(Widget parent)
{
  Widget  xtitle, xlabel, xb_quit;
  char    title[64];
  Arg     args[7];
  int     i = 0;

  xtitle = XmCreateForm(parent, "title", NULL, 0);
  XtManageChild(xtitle);

  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Quit", XmSTRING_DEFAULT_CHARSET));  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);  i++;
  xb_quit = XmCreatePushButton(xtitle, "quit", args, i);
  XtAddCallback(xb_quit, XmNactivateCallback, 
		(XtCallbackProc)cb_quit, 0);
  XtManageChild(xb_quit);

  i = 0;
  sprintf(title, "XMDVI version %s" , XMDVI_VERSION);
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate(title, XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNrightAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNrightWidget, xb_quit);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);  i++;
  xlabel = XmCreateLabel(xtitle, "title", args, i);
  XtManageChild(xlabel);

  return xtitle;
}

Private Widget
x_mpm_cmd(Widget parent)
{
  Widget  xcmdp, xrc;
  Widget  xb_reload, xb_print, xb_paper, xb_file, xb_mag, xb_opt;
  Arg     args[5];
  int     i;

  xcmdp = XmCreateForm(parent, "cmdPanel", NULL, 0);
  XtManageChild(xcmdp);

  i = 0;
  XtSetArg(args[i], XmNorientation, XmHORIZONTAL);  i++;
  XtSetArg(args[i], XmNnumColumns, 2);  i++;
  XtSetArg(args[i], XmNpacking, XmPACK_COLUMN);  i++;
  XtSetArg(args[i], XmNentryAlignment, XmALIGNMENT_CENTER);  i++;
  xrc = XmCreateRowColumn(xcmdp, "cmd", args, i);
  XtManageChild(xrc);

  /* Reload */
  XtSetArg(args[0], XmNlabelString, 
	   XmStringCreate("Reload", XmSTRING_DEFAULT_CHARSET));
  xb_reload = XmCreatePushButton(xrc, "reload", args, 1);
  XtAddCallback(xb_reload, XmNactivateCallback, 
		(XtCallbackProc)cb_reload, NULL);
  XtManageChild(xb_reload);
  /* Magnification */
  XtSetArg(args[0], XmNlabelString, 
	   XmStringCreate("Magnification...", XmSTRING_DEFAULT_CHARSET));
  xb_mag = XmCreatePushButton(xrc, "mag", args, 1);
  XtAddCallback(xb_mag, XmNactivateCallback, (XtCallbackProc)cb_mag, NULL);
  XtManageChild(xb_mag);
  /* Print */
  XtSetArg(args[0], XmNlabelString, 
	   XmStringCreate("Printer...", XmSTRING_DEFAULT_CHARSET)); 
  xb_print  = XmCreatePushButton(xrc, "print", args, 1);
  XtAddCallback(xb_print, XmNactivateCallback, (XtCallbackProc)cb_print, NULL);
  XtManageChild(xb_print);

  /* File */
  XtSetArg(args[0], XmNlabelString, 
	   XmStringCreate("File...", XmSTRING_DEFAULT_CHARSET)); 
  xb_file   = XmCreatePushButton(xrc, "file", args, 1);
  XtAddCallback(xb_file, XmNactivateCallback,
		(XtCallbackProc)cb_file, NULL);
  XtManageChild(xb_file);
  /* Paper */
  XtSetArg(args[0], XmNlabelString, 
	   XmStringCreate("Paper...", XmSTRING_DEFAULT_CHARSET));
  xb_paper   = XmCreatePushButton(xrc, "paper", args, 1);
  XtAddCallback(xb_paper, XmNactivateCallback, 
		(XtCallbackProc)cb_paper, NULL);
  XtManageChild(xb_paper);
  /* Option */
  XtSetArg(args[0], XmNlabelString, 
	   XmStringCreate("Options...", XmSTRING_DEFAULT_CHARSET)); 
  xb_opt = XmCreatePushButton(xrc, "option", args, 1);
  XtAddCallback(xb_opt, XmNactivateCallback, (XtCallbackProc)cb_option, NULL);
  XtManageChild(xb_opt);

  return xcmdp;
}

Private Widget
x_mpm_page(Widget parent)
{
  Widget  xpage, xb_title, xrc; 
  Widget  xb_prev, xb_next;
  Arg     args[15];
  int     i;

  xpage = XmCreateForm(parent, "page", NULL, 0);
  XtManageChild(xpage);

  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Page", XmSTRING_DEFAULT_CHARSET));  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  xb_title = XmCreateLabel(xpage, "label", args, i);
  XtManageChild(xb_title);

  i = 0;
  XtSetArg(args[i], XmNorientation, XmHORIZONTAL);  i++;
  XtSetArg(args[i], XmNentryAlignment, XmALIGNMENT_CENTER);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNtopWidget, xb_title); i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);  i++;
  xrc = XmCreateRowColumn(xpage, "pageButtons", args, i);
  XtManageChild(xrc);
  x_page_panel = xrc;

  /* Prev */
  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("  Prev  ", XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNhighlightThickness, 0); i++;
  xb_prev  = XmCreatePushButton(xrc, "prev", args, i);
  XtAddCallback(xb_prev, XmNactivateCallback, 
		(XtCallbackProc)cb_page_prev, NULL);
  XtManageChild(xb_prev);
  /* Next */
  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("  Next  ", XmSTRING_DEFAULT_CHARSET));  i++;
  XtSetArg(args[i], XmNhighlightThickness, 0); i++;
  xb_next = XmCreatePushButton(xrc, "next", args, i);
  XtAddCallback(xb_next, XmNactivateCallback, 
		(XtCallbackProc)cb_page_next, NULL);
  XtManageChild(xb_next);

  /* Slider */
  i = 0;
  XtSetArg(args[i], XmNorientation, XmHORIZONTAL); i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNrightAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNprocessingDirection, XmMAX_ON_RIGHT);  i++;
  XtSetArg(args[i], XmNshowValue, TRUE);  i++;
  XtSetArg(args[i], XmNleftWidget, xrc); i++;
  x_page_jump_slider = XmCreateScale(xrc, "slider", args, i);
  XtAddCallback(x_page_jump_slider, XmNvalueChangedCallback, 
		(XtCallbackProc)cb_page_jump, NULL);
  XtManageChild(x_page_jump_slider);

  return xpage;
}

Public void
ui_close_panel_all(void)
{
  cb_print_close(NULL, 0, 0);
  cb_option_close(NULL, 0, 0);
  cb_mag_close(NULL, 0, 0);
  cb_file_close(NULL, 0, 0);
  cb_paper_close(NULL, 0, 0);
  cb_quit_close(NULL, 0, 0);
}


Private void
cb_page_jump(Widget w, caddr_t d1, caddr_t d2)
{
  Arg   arg;
  int   page;

  if (DviFile == NULL){
    x_bell();
    return;
  }
  XtSetArg(arg, XmNvalue, &page);
  XtGetValues(w, &arg, 1);
  cmd_goto_page(page);
}

Private void
cb_page_prev(Widget w, caddr_t d1, caddr_t d2)
{
  cmd_page_prev(1);
}

Private void
cb_page_next(Widget w, caddr_t d1, caddr_t d2)
{
  cmd_page_next(1);
}


Public void
cmd_redraw(void) 
{
  if (DviDisableCommand == 1)
    return;
  if (DviFile == NULL){
    x_bell();
    return;
  }
  x_ui_command = UI_CMD_REDRAW;
}

Public void
cmd_page_prev(int npages)
{
  if (DviDisableCommand == 1)
    return;
  cmd_goto_page(DviCurrentPage-npages);
}

Public void
cmd_page_next(int npages)
{
  if (DviDisableCommand == 1)
    return;
  cmd_goto_page(DviCurrentPage+npages);
}

Public void
cmd_goto_page(int page)
{
  Arg   arg;

  if (DviDisableCommand == 1)
    return;
  if (DviFile == NULL){
    x_bell();
    return;
  }
  if (page <= 0){
    x_bell();
    page = 1;
  }
  if (DviFile->pages < page){
    x_bell();
    page = DviFile->pages;
  }
  if (DviCurrentPage == page)
    return;

  DviCurrentPage = page;
  XtSetArg(arg, XmNvalue, page);
  XtSetValues(x_page_jump_slider, &arg, 1);

  x_ui_command = UI_CMD_PAGE;
  return;
}

Public void
ui_set_page_jump_range(void)
{
  Arg         args[5];
  int         i;
  static int  mp = 1;

  if ((DviFile == NULL)|| (DviFile->pages <= 1)){
    XtUnmapWidget(x_page_panel);
    mp = 0;
    return;
  }

  i = 0;
  XtSetArg(args[i], XmNminimum, 1); i++;
  XtSetArg(args[i], XmNmaximum, DviFile->pages); i++;
  XtSetArg(args[i], XmNvalue, DviCurrentPage); i++;
  XtSetValues(x_page_jump_slider, args, i);

  if (mp == 0){
    XtMapWidget(x_page_panel);
    mp = 1;
  }
}




Private Widget
x_mpm_message(Widget parent)
{
  Widget xbb, xtitle, xls;
  Arg    args[10];
  int    i;

  xbb = XmCreateForm(parent, "message", NULL, 0);
  XtManageChild(xbb);
  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Message", XmSTRING_DEFAULT_CHARSET));  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  xtitle = XmCreateLabel(xbb, "label", args, i);
  XtManageChild(xtitle);
  i = 0;
  XtSetArg(args[i], XmNitemCount, 0); i++;
  XtSetArg(args[i], XmNlistSizePolicy, XmCONSTANT); i++;
  XtSetArg(args[i], XmNscrollBarDisplayPolicy, XmSTATIC); i++;
  XtSetArg(args[i], XmNscrollBarPlacement, XmTOP_LEFT); i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNtopWidget, xtitle);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNvisibleItemCount, RES(DviDev,msg_window_size));  i++;
  xls = XmCreateScrolledList(xbb, "messageList", args, i);
  XtManageChild(xls);
  x_w_message = xls;

  return xbb;
}

Public void
x_vmessage(char *fmt,...)
{
  va_list   ap;
  char      msg[512];

  va_start(ap, fmt);
  vsprintf(msg, fmt, ap);
  x_message(msg);
  va_end(ap);
}

Public void
x_message(char *msg)
{
  XmString  xmsg;
  XEvent    xev;
  static int   count = 0; 

  xmsg = XmStringCreate(msg, XmSTRING_DEFAULT_CHARSET);
  XmListAddItemUnselected(x_w_message, xmsg, 0);
  XmStringFree(xmsg);

  ++count;
  if (count > RES(DviDev,msg_history_size)){
    --count;
    XmListDeletePos(x_w_message, 1);
  }
  XmListSetBottomPos(x_w_message, 0);

  XFlush(XtDisplay(x_w_message));
  while (XtPending()){
    XtNextEvent(&xev);
    XtDispatchEvent(&xev);
  }
  XFlush(XtDisplay(x_w_message));
}

Public void
x_error_vmessage(char *fmt,...)
{
  va_list   ap;
  char      msg[512];

  va_start(ap, fmt);
  vsprintf(msg, fmt, ap);
  x_message(msg);
  va_end(ap);
}

Public void
x_error_message(char *msg)
{
  x_message(msg);
}

Public void
x_message_advice(char *msg)
{
  if (RES(DviDev,novice) == 1)
    x_message(msg);
}

Public void
x_vmessage_advice(char *fmt,...)
{
  va_list   ap;
  char      msg[512];

  if (RES(DviDev,novice) == 0)
    return;

  va_start(ap, fmt);
  vsprintf(msg, fmt, ap);
  x_message(msg);
  va_end(ap);
}
