/*
 * xmdvi, a previewer for TeX on X-Window using OSF/Motif
 * by Hirotsugu Kakugawa
 *
 *   1 Mar 1996  Version 1.0 based on DVIlib 1.0 and VFlib 2
 *  19 Feb 1997  Version 2.0 based on DVIlib 2.1 and VFlib 3.1
 *  21 Feb 1997  Version 2.1 based on DVIlib 2.2
 *   3 Mar 1997  Version 2.2.2
 *   7 Mar 1997  Version 2.2.3
 *   3 Jun 1997  Version 2.3  Added vflibcap parameterlization
 *               feature for vflibcap.
 *  29 Mar 1999  Added asynchronous gs process invocation.
 */
/*
 * Copyright (C) 1996-1999 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <ctype.h>
#if defined(HAVE_STRING_H) || defined(STDC_HEADERS)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/Xresource.h>
#include "libdvi29.h"
#include "defs.h"
#include "dev.h"
#include "cf-xmdvi.h"
#include "resource.h"
#include "window.h"
#include "../params.h"

Public DVI_DEVICE    DviDev;
Public DVI           DviFile;
Public DVI_PROPERTY  DviProperty;
Public char*         DviFileName;
Public char*         DviFileNameBase;
Public char*         DviFileNameNew;
Public int           DviCurrentPage;
Public double        DviShrinkFactor;
Public int           DviEPSRendering;
Public int           DviVisualText;
Public int           DviVisualEPS;
Public int           DviDisableCommand;  /* See DEV_poll() and cmd_XXX() */

Private void  startup_message(void);
Private int   new_dvi_file(int);



Public int
main(int argc, char **argv)
{
  int  next_cmd;
  char  params[3*256];

  DviDev            = NULL;
  DviFile           = NULL;
  DviFileName       = NULL;
  DviFileNameBase   = NULL;
  DviFileNameNew    = NULL;
  DviShrinkFactor   = 1.0;
  DviCurrentPage    = 1;
  DviEPSRendering   = 0;
  DviVisualText     = VISUAL_RGB;
  DviVisualEPS      = VISUAL_RGB;
  DviDisableCommand = 0;

  /* Open X display */ 
  if (x_open_display() < 0){
    fprintf(stderr, "Can't open X display...\n");
    exit(1);
  }

  /* Create X Window device */
  if ((DviDev = dvi_device_create(argc, argv, 1)) == NULL){
    fprintf(stderr, "Failed to initialize device.\n");    
    exit(1);
  }
  DviShrinkFactor = RES(DviDev,shrink);
  DviEPSRendering = RES(DviDev,draw_eps);
  
  /* Create UI system */
  x_ui_make();
  startup_message();

  /* Parameters for vflibcap */
  sprintf(params, "%s=%d, %s=%s, %s=%s", 
	  PARAM_NAME_DPI,  RES(DviDev,dpi),
	  PARAM_NAME_MODE, RES(DviDev,kpathsea_mode),
	  PARAM_NAME_PROG, "xmdvi");
  
  /* Init DVILIB */
  if (DVI_INIT(RES(DviDev,vflibcap), params) < 0){
    fprintf(stderr, "Failed to initialize dvi interpreter.\n");
    exit(1);
  }

  /* Main Loop */
  next_cmd = UI_CMD_LOAD;
  for (;;){
    switch (next_cmd){
    case UI_CMD_QUIT:
      do_exit();
    default:
      next_cmd = UI_CMD_LOAD;
    case UI_CMD_LOAD:
    case UI_CMD_RELOAD:
      new_dvi_file(next_cmd);
    }
    next_cmd = x_ui_loop();
  }

  return 0;
}

Public void
do_exit(void)
{
#if 0
#if HAVE_KILLPG
  killpg(0, SIGINT);
#else
  kill(0, SIGINT);
#endif
#endif

  exit(0);
}

Private void
startup_message(void)
{
  char  msg[160];
  
  sprintf(msg, "XMDVI Version %s", XMDVI_VERSION);
  x_message(msg);
  x_message("Copyright (C) 1997 Hirotsugu Kakugawa. All rights reserved.");
  x_message("Xmdvi is distributed in the hope that it will be useful,");
  x_message("but WITHOUT ANY WARRANTY. See the GNU General ");
  x_message("Public License for more details.");
  x_message("");
}

Private int
new_dvi_file(int cmd)
{
  DVI   dvi;

  if (DviFileNameNew == NULL){
    x_cursor_change(CURSOR_READY);
    return 0;
  }

  x_cursor_change(CURSOR_READING);

  DEV_CALL(DviDev,message_advice)(DviDev,DviFile,
				  "Reading %s...", DviFileNameNew);

  if (DviProperty == NULL){
    DviProperty = DVI_PROPERTY_ALLOC_DEFAULT();
    if (DviProperty != NULL){
      DVI_PROPERTY_SET(DviProperty, DVI_PROP_ASYNC_GS_INVOCATION);
      DVI_PROPERTY_SET(DviProperty, DVI_PROP_INCREMENTAL_EPS_DISPLAY);
      switch (RES(DviDev,eps_style)){
      default:
      case EPS_STYLE_LATEX2E_GRAPHICS_STY:
	DVI_PROPERTY_SET(DviProperty,   DVI_PROP_LATEX2E_GRAPHICS_STY);
	DVI_PROPERTY_UNSET(DviProperty, DVI_PROP_LATEX209_EPSF_STY);
	break;
      case EPS_STYLE_LATEX209_EPSF_STY:
	DVI_PROPERTY_UNSET(DviProperty, DVI_PROP_LATEX2E_GRAPHICS_STY);
	DVI_PROPERTY_SET(DviProperty,   DVI_PROP_LATEX209_EPSF_STY);
	break;
      }
    }
  }

  dvi = DVI_CREATE(DviDev, DviFileNameNew, DviProperty);
  if (dvi == NULL){
    DEV_CALL(DviDev,message_error)(DviDev,DviFile, 
				   "This is not a correct DVI file.");
    goto Error;
  }
  DEV_CALL(DviDev,message_advice)(DviDev,DviFile,"Opening fonts...");
  if (DVI_OPEN_FONT(dvi, DviDev) < 0){
    DEV_CALL(DviDev,message_error)(DviDev,DviFile,"Cannot open all fonts.");
    DVI_DISPOSE(dvi,DviDev);
    goto Error;
  }
  DEV_CALL(DviDev,message_advice)(DviDev,DviFile,"done.");

  if (DviFileName != NULL)
    free(DviFileName);

  DviFileName     = DviFileNameNew;
  DviFileNameNew  = NULL;
  DviFileNameBase = rindex(DviFileName, '/');
  if (DviFileNameBase == NULL)
    DviFileNameBase = DviFileName;

  if (DviFile != NULL)
    DVI_DISPOSE(DviFile,DviDev);
  DviFile        = dvi;

  if (cmd == UI_CMD_RELOAD){
    if (DviCurrentPage > dvi->pages)
      DviCurrentPage = dvi->pages;
  } else {
    DviCurrentPage = 1;
  }
  x_reset_colors();
  x_cancel_page_cache();
  x_ui_command = UI_CMD_PAGE;
  return 0;

Error:
  if (DviFileNameNew != NULL){
    free(DviFileNameNew);
    DviFileNameNew = NULL;
  }
  x_bell();
  x_cursor_change(CURSOR_READY);
  x_ui_command = UI_CMD_NONE;
  return -1;
}


#if !HAVE_STRCASECMP
int strcasecmp(char *s1, char *s2)
{
  while ((*s1 != '\0') && (*s2 != '\0')){
    if (toupper(*s1) != toupper(*s2))
      return 1;
    s1++;
    s2++;
  }
  if (toupper(*s1) != toupper(*s2))
    return 1;
  return 0;
}
#endif

/*EOF*/
