% Conversion my transkriptie -> transcription for devnag
%
% alphabet:
%   OM a/* aa i ii u uu .r .r.r .l .l.l e ai o au .a  a" o"
%
%   a~ aM aH
%
%   ka kha ga gha n" qa Kha Ga
%   ca cha ja jha n~        za
%   Ta Tha Da Dha Na        Ra Rha
%   ta tha da dha na
%   pa pha ba bha ma    fa
%   ya ra la va         r"
%   sha Sa sa ha La
%
%   0 1 2 3 4 5 6 7 8 9
%
%   ` `` '' '  ! ?  . , : ; | ( ) /
%
%   + @ # ^ ^^ > 
%
% author:
%   Jeroen Hellingman <jhelling@cs.ruu.nl>
%   't Zand 2, 4133 TB Vianen, The Netherlands

@patterns 0 patterns for normal ASCII
"$"             1 "{\\dn "      begin devanagari
"<hindi>"       1 "{\\dn "
"<marathi>"     1 "{\\dn "
"<nepali>"      1 "{\\dn "
"<sanskrit>"    1 "{\\dn "
"$$"            2 "{\\dntr "    begin devanagari in transcription
"<hindi.transcription>"     1 "{\\dn "
"<marathi.transcription>"   1 "{\\dn "
"<nepali.transcription>"    1 "{\\dn "
"<sanskrit.transcription>"  1 "{\\dn "
"%"         c               skip comments
"\\"        t               skip TeX-command.
"\t"        p " "           tab -> space (for devnag)

@rpatterns 1 patterns my transcription -> devnag transcription

"$"             0 "}"
"</hindi>"      0 "}"
"</marathi>"    0 "}"
"</nepali>"     0 "}"
"</sanskrit>"   0 "}"
"$$"            e "$$ while in $-mode"
"%"             c
"\\"            t

"a"         p "a"
"*"         p "a"               silent a ($kar*naa$ = to work)
"aa"        p "A"
"i"         p "i"
"ii"        p "I"
"u"         p "u"
"uu"        p "U"
".r"        p ".r"
".rr"       e "old transcription .rr -> .r.r"
".r.r"      p ".R"
".l"        p ".l"
".ll"       e "old transcription .ll -> .l.l"
".l.l"      p ".L"
"e"         p "e"
"ai"        p "E"
"o"         p "o"
"au"        p "O"


"k"         p "k"
"kh"        p "K"
"g"         p "g"
"gh"        p "G"
"n\""       p "\"n"
"q"         p "q"
".kh"       e "old transcription .kh -> Kh"
"Kh"        p ".K"
".g"        e "old transcription .g -> G"
"G"         p ".g"
"c"         p "c"
"ch"        p "C"
"j"         p "j"
"jh"        p "J"
"n~"        p "~n"
"z"         p "z"
".t"        e "old transcription .t -> T"
"T"         p ".t"
".th"       e "old transcription .th -> Th"
"Th"        p ".T"
".d"        e "old transcription .d -> D"
"D"         p ".d"
".dh"       e "old transcription .dh -> Dh"
"Dh"        p ".D"
".n"        e "old transcription .n -> N"
"N"         p ".n"
"R"         p "R"
"Rh"        p "Rh"
"t"         p "t"
"th"        p "T"
"d"         p "d"
"dh"        p "D"
"n"         p "n"
"p"         p "p"
"ph"        p "P"
"b"         p "b"
"bh"        p "B"
"m"         p "m"
"f"         p "f"
"y"         p "y"
"r"         p "r"
"l"         p "l"
"v"         p "v"
"w"         e "old transcription w -> v"
"sh"        p "\"s"
".s"        e "old transcription .s -> S"
"S"         p ".s"
"s"         p "s"
"h"         p "h"
"x"         e "old transcription x -> kS"
"L"         p "L"               Marathi l
"r\""       p "~r"              Marathi r
".a"        p ".a"              ahagraha
"OM"        p ".o"              O...M
"a\""       p "~a"              English a (Marathi)
"o\""       p "~o"              English o
".m"        e "old transcription .m -> M"
"M"         p "M"               anusvara
"~"         p "/"               candrabindu: gets a special treatment
".h"        e "old transcription .h -> H"
"H"         p ".h"              visarga
"|"         p "|"               dand
"@"         p "@"               abbreviation circle
"."         p ".."              period
"#"         p "#"               centered period
"+"         p "&"               viram
"^"         p ""                ^ and ^^ dissappear in devanaagarii
"<"         p ""                dissappears by definition
">"         p ""                dissappears
"{"         p "{"               TeX-braces
"}"         p "}"
"\n"        p "\n"
","         p ","
":"         p ":"
";"         p ";"
"-"         p "-"
"["         p "["
"]"         p "]"
"("         p "("
")"         p ")"
"?"         p "?"
"!"         p "!"
"`"         p "`"
"'"         p "'"
"/"     p "{\\slash}"
"0"         p "0"
"1"         p "1"
"2"         p "2"
"3"         p "3"
"4"         p "4"
"5"         p "5"
"6"         p "6"
"7"         p "7"
"8"         p "8"
"9"         p "9"
" "         p " "
"\t"        p " "           tab -> space

% no candrabindu if matra above headline (does not function correctly with reph)

"i~"        p "iM"
"ii~"       p "IM"
"e~"        p "eM"
"ai~"       p "EM"
"o~"        p "oM"
"au~"       p "OM"
" e~"       p " e/"         but remain candrabindu on front e
"\ne~"      p "\ne/"        idem
"\te~"      p " e/"         idem
"-e~"       p "-e/"         idem
"ae~"       p "ae/"
"aae~"      p "Ae/"
"ie~"       p "ie/"
"iie~"      p "Ie/"
"ue~"       p "ue/"
"uue~"      p "Ue/"
"aie~"      p "Ee/"
"oe~"       p "oe/"
"aue~"      p "Oe/"

@rpatterns 2 patterns my transcription -> transcription in TeX

"$"             e "$ while in $$-mode"
"$$"            0 "}"
"</hindi>"      0 "}"
"</marathi>"    0 "}"
"</nepali>"     0 "}"
"</sanskrit>"   0 "}"
"^^"            3 ""            Go to capital-mode
"%"             c
"\\"            t
"\t"            p " "           tab -> spacie
"^"             e "^ in front of non-letter"

"a"         p "a"
"*"         p ""            silent a ($kar*naa$ = to work)
"aa"        p "\\=a"
"i"         p "i"
"ii"        p "{\\=\\i}"
"u"         p "u"
"uu"        p "\\=u"
".r"        p "\\d r"
".rr"       e "old transcription .rr -> .r.r"
".r.r"      p "{\\rii}"     TeX macro \rii
".l"        p "\\d l"
".ll"       e "old transcription .ll -> .l.l"
".l.l"      p "{\\lii}"     TeX macros \lii
"e"         p "e"
"ai"        p "ai"
"o"         p "o"
"au"        p "au"

"k"         p "k"
"kh"        p "kh"
"g"         p "g"
"gh"        p "gh"
"n\""       p "\\.n"
"q"         p "q"
".kh"       e "old transcription .kh -> Kh"
"Kh"        p "{\\kh}"      Tex macro \kh
".g"        e "old transcription .g -> G"
"G"         p "{\\g}"       Tex macro \g
"c"         p "c"
"ch"        p "ch"
"j"         p "j"
"jh"        p "jh"
"n~"        p "\\~n"
"z"         p "z"
".t"        e "old transcription .t -> T"
"T"         p "\\d t"
".th"       e "old transcription .th -> Th"
"Th"        p "\\d th"
".d"        e "old transcription .d -> D"
"D"         p "\\d d"
".dh"       e "old transcription .dh -> Dh"
"Dh"        p "\\d dh"
".n"        e "old transcription .n -> N"
"N"         p "\\d n"
"R"         p "\\d r"
"Rh"        p "\\d rh"
"t"         p "t"
"th"        p "th"
"d"         p "d"
"dh"        p "dh"
"n"         p "n"
"p"         p "p"
"ph"        p "ph"
"b"         p "b"
"bh"        p "bh"
"m"         p "m"
"f"         p "f"
"y"         p "y"
"r"         p "r"
"l"         p "l"
"v"         p "v"
"w"         e "old transcription w -> v"
"sh"        p "\\'s"
"\"s"       e "old transcription \"s -> sh"
".s"        e "old transcription .s -> S"
"S"         p "\\d s"
"s"         p "s"
"h"         p "h"
"x"         e "old transcription x -> kS"
"L"         p "\\d l"       Marathi l
"r\""       p "r"           Marathi eyelash r
".a"        p "a"           ahagraha
"OM"        p "O\\dots M"   O...M
"a\""       p "\\^e"       English a (Marathi)
"o\""       p "\\^o"       English o
".m"        e "old transcription .m -> M"
"M"         p "\\d m"       anusvara: see below
"~"         p "\\.m"        candrabindu: treated specially
".h"        e "old transcription .h -> H"
"H"         p "\\d h"       visarga
"|"         p "."           dand
" |"        p "."           eat space before dand
"||"        p "."           dubble dand
"@"         p "."           abbreviation
"."         p "."           period
"###"       p "{\\dots}"
"#"         p "."           centered period
"+"         p ""            viram
"<"         p ""            stop ambiguity; dissappears by definition
">"         p " "           becomes space
"{"         p "{"           TeX-braces
"}"         p "}"
"\n"        p "\n"
","         p ","
":"         p ":"
";"         p ";"
"-"         p "-"
"["         p "["
"]"         p "]"
"("         p "("
")"         p ")"
"?"         p "?"
"!"         p "!"
"`"         p "`"
"'"         p "'"
"/"         p "/"
"0"         p "0"
"1"         p "1"
"2"         p "2"
"3"         p "3"
"4"         p "4"
"5"         p "5"
"6"         p "6"
"7"         p "7"
"8"         p "8"
"9"         p "9"
" "         p " "

% repeat partial table for correct transcription of anusvar

"Mk"        p "\\.nk"
"Mkh"       p "\\.nkh"
"Mg"        p "\\.ng"
"Mgh"       p "\\.ngh"
"Mq"        p "\\.nq"
"MKh"       p "\\.n{\\kh}"
"MG"        p "\\.n{\\g}"
"Mh"        p "\\.nh"

"Mc"        p "\\~nc"
"Mch"       p "\\~nch"
"Mj"        p "\\~nj"
"Mjh"       p "\\~njh"
"Msh"       p "\\~n\\'s"
"My"        p "\\~ny"

"MT"        p "\\d n\\d t"
"MTh"       p "\\d n\\d th"
"MD"        p "\\d n\\d d"
"MDh"       p "\\d n\\d dh"
"MS"        p "\\d n\\d s"
"Mr"        p "\\d nr"

"Mt"        p "nt"
"Mth"       p "nth"
"Md"        p "nd"
"Mdh"       p "ndh"
"Ms"        p "ns"
"Ml"        p "nl"

"Mp"        p "mp"
"Mph"       p "mph"
"Mb"        p "mb"
"Mbh"       p "mbh"
"Mf"        p "mf"

% part for correct translation candrabindu

"a~"        p "\\~a"
"aa~"       p "\\ltwig{a}"
"i~"        p "{\\~\\i}"
"ii~"       p "\\ltwig{\\i}"
"u~"        p "\\~u"
"uu~"       p "\\ltwig{u}"
"e~"        p "\\~e"
"ai~"       p "a{\\~\\i}"
"o~"        p "\\~o"
"au~"       p "a\\~u"

% part for capitals

"^a"        p "A"
"^aa"       p "\\=A"
"^i"        p "I"
"^ii"       p "\\=I"
"^u"        p "U"
"^uu"       p "\\=U"
"^.r"       p "\\d R"
"^.r.r"     p "{\\Rii}"     TeX macro \Rii
"^.l"       p "\\d L"
"^.l.l"     p "{\\Lii}"     TeX macro \Lii
"^e"        p "E"
"^ai"       p "Ai"
"^o"        p "O"
"^au"       p "Au"

"^k"        p "K"
"^kh"       p "Kh"
"^g"        p "G"
"^gh"       p "Gh"
"^n\""      p "\\.N"
"^q"        p "Q"
"^Kh"       p "{\\Kh}"      Tex macro \Kh
"^G"        p "{\\G}"       Tex macro \G
"^c"        p "C"
"^ch"       p "Ch"
"^j"        p "J"
"^jh"       p "Jh"
"^n~"       p "\\~N"
"^z"        p "Z"
"^T"        p "\\d T"
"^Th"       p "\\d Th"
"^D"        p "\\d D"
"^Dh"       p "\\d Dh"
"^N"        p "\\d N"
"^R"        p "\\d R"
"^Rh"       p "\\d Rh"
"^t"        p "T"
"^th"       p "Th"
"^d"        p "D"
"^dh"       p "Dh"
"^n"        p "N"
"^p"        p "P"
"^ph"       p "Ph"
"^b"        p "B"
"^bh"       p "Bh"
"^m"        p "M"
"^f"        p "F"
"^y"        p "Y"
"^r"        p "R"
"^l"        p "L"
"^v"        p "V"
"^sh"       p "\\'S"
"^S"        p "\\d S"
"^s"        p "S"
"^h"        p "H"
"^L"        p "\\d L"       Marathi l
"^r\""      p "R"           Marathi eyelash r
"^.a"       p "A"           ahagraha
"^a\""      p "\\^E"       English a (Marathi)
"^o\""      p "\\^O"       English o

% part for correct translation candrabindu

"^a~"       p "\\~A"
"^aa~"      p "\\ltwig{A}"
"^i~"       p "{\\~\\i}"
"^ii~"      p "\\ltwig{I}"
"^u~"       p "\\~U"
"^uu~"      p "\\ltwig{U}"
"^e~"       p "\\~E"
"^ai~"      p "A{\\~\\i}"
"^o~"       p "\\~O"
"^au~"      p "A\\~u"

@rpatterns 3 patterns my transcription -> transcription in TeX (capitals)

"$"             e "$ while in $$-mode"
"$$"            0 "}"
"</hindi>"      0 "}"
"</marathi>"    0 "}"
"</nepali>"     0 "}"
"</sanskrit>"   0 "}"
"^^"            2 ""            Go to small-letter-mode
"%"             c
"\\"            t
"^"             p ""            forget this one now

"a"         p "A"
"*"         p ""            silent a ($kar*naa$ = to work)
"aa"        p "\\=A"
"i"         p "I"
"ii"        p "\\=I"
"u"         p "U"
"uu"        p "\\=U"
".r"        p "\\d R"
".rr"       e "old transcription .rr -> .r.r"
".r.r"      p "{\\Rii}"     TeX macro \Rii
".l"        p "\\d L"
".ll"       e "old transcription .ll -> .l.l"
".l.l"      p "{\\Lii}"     TeX macro \Lii
"e"         p "E"
"ai"        p "AI"
"o"         p "O"
"au"        p "AU"

"k"         p "K"
"kh"        p "KH"
"g"         p "G"
"gh"        p "GH"
"n\""       p "\\.N"
"q"         p "Q"
".kh"       e "old transcription .kh -> Kh"
"Kh"        p "{\\KH}"      Tex macro \KH
".g"        e "old transcription .g -> G"
"G"         p "{\\G}"       Tex macro \G
"c"         p "C"
"ch"        p "CH"
"j"         p "J"
"jh"        p "JH"
"n~"        p "\\~N"
"z"         p "Z"
".t"        e "old transcription .t -> T"
"T"         p "\\d T"
".th"       e "old transcription .th -> Th"
"Th"        p "\\d TH"
".d"        e "old transcription .d -> d"
"D"         p "\\d D"
".dh"       e "old transcription .dh -> Dh"
"Dh"        p "\\d DH"
".n"        e "old transcription .n -> N"
"N"         p "\\d N"
"R"         p "\\d R"
"Rh"        p "\\d RH"
"t"         p "T"
"th"        p "TH"
"d"         p "D"
"dh"        p "DH"
"n"         p "N"
"p"         p "P"
"ph"        p "PH"
"b"         p "B"
"bh"        p "BH"
"m"         p "M"
"f"         p "F"
"y"         p "Y"
"r"         p "R"
"l"         p "L"
"v"         p "V"
"w"         e "old transcription w -> v"
"sh"        p "\\'S"
"\"s"       e "old transcription \"s -> sh"
".s"        e "old transcription .s -> S"
"S"         p "\\d S"
"s"         p "S"
"h"         p "H"
"x"         e "old transcription x -> kS"
"L"         p "\\d L"       Marathi l
"r\""       p "R"           Marathi eyelash r
".a"        p "A"           ahagraha
"OM"        p "O\\dots M"   O...M
"a\""       p "\\^E"       English a (Marathi)
"o\""       p "\\^O"       English o
".m"        e "old transcription .m -> M"
"M"         p "\\d M"       anusvara: see below
"~"         p "\\.M"        candrabindu: treated specially
".h"        e "old transcription .h -> H"
"H"         p "\\d H"       visarga
"|"         p "."           dand
" |"        p "."           eat space in front of dand
"||"        p "."           dubble dand
"@"         p "."           abbreviation
"."         p "."           period
"###"       p "{\\dots}"
"#"         p "."           centered period
"+"         p ""            viram
"<"         p ""            remove ambiguity; dessapears by definition
">"         p " "           becomes space
"{"         p "{"           TeX-braces
"}"         p "}"
"\n"        p "\n"
","         p ","
":"         p ":"
";"         p ";"
"-"         p "-"
"["         p "["
"]"         p "]"
"("         p "("
")"         p ")"
"?"         p "?"
"!"         p "!"
"`"         p "`"
"'"         p "'"
"/"         p "/"
"0"         p "0"
"1"         p "1"
"2"         p "2"
"3"         p "3"
"4"         p "4"
"5"         p "5"
"6"         p "6"
"7"         p "7"
"8"         p "8"
"9"         p "9"
" "         p " "

% repeat part for correct transcription anusvara

"Mk"        p "\\.NK"
"Mkh"       p "\\.NKH"
"Mg"        p "\\.NG"
"Mgh"       p "\\.NGH"
"Mq"        p "\\.NQ"
"MKh"       p "\\.N{\\KH}"
"MG"        p "\\.N{\\G}"
"Mh"        p "\\.NH"

"Mc"        p "\\~NC"
"Mch"       p "\\~NCH"
"Mj"        p "\\~NJ"
"Mjh"       p "\\~NJH"
"Msh"       p "\\~N\\'S"
"My"        p "\\~NY"

"MT"        p "\\d N\\d T"
"MTh"       p "\\d N\\d TH"
"MD"        p "\\d N\\d D"
"MDh"       p "\\d N\\d DH"
"MS"        p "\\d N\\d S"
"Mr"        p "\\d NR"

"Mt"        p "NT"
"Mth"       p "NTH"
"Md"        p "ND"
"Mdh"       p "NDH"
"Ms"        p "NS"
"Ml"        p "NL"

"Mp"        p "MP"
"Mph"       p "MPH"
"Mb"        p "MB"
"Mbh"       p "MBH"
"Mf"        p "MF"

% part for correct translation candrabindu

"a~"        p "\\~A"
"aa~"       p "\\ltwig{A}"
"i~"        p "\\~I"
"ii~"       p "\\ltwig{I}"
"u~"        p "\\~U"
"uu~"       p "\\ltwig{U}"
"e~"        p "\\~E"
"ai~"       p "A\\~I"
"o~"        p "\\~O"
"au~"       p "A\\~U"

@end
