%%
%% This is file `protocol.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% protocol.dtx  (with options: `protocol')
%% 
%% This is a generated file.
%% Copyright (C) 1997-1999 Thomas Leineweber, University of Dortmund.
%% 
%% This file may be distributed under the terms of the LaTeX Project Public
%% License, as described in lppl.txt in the base LaTeX distribution.
%% Either version 1.0 or, at your option, any later version.
%% 
%% For error reports in case of UNCHANGED versions see the readme file.
%% 
%% Please do not request updates from me directly.  Distribution is
%% done through the Comprehensive TeX Archive Network (CTAN).
%% 
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{protocol}
              [1998/07/30 v1.7a
               LaTeX-Class fuer Sitzungs-Protokolle TL]
\DeclareOption{a5paper}
     {\ClassError{protocol}{Option `a5paper' not supported}{}}
\DeclareOption{b5paper}
     {\ClassError{protocol}{Option `b5paper' not supported}{}}
\DeclareOption{twocolumn}
     {\ClassError{protocol}{Option `twocolumn' not supported}{}}
\DeclareOption{titlepage}
     {\ClassError{protocol}{Option `titlepage' not supported}{}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax
\LoadClass{article}
\def\groupname#1{\gdef\@groupname{#1}}
\def\chair#1{\gdef\@chair{#1}}
\def\writer#1{\gdef\@writer{#1}}
\def\begintime#1{\gdef\@begintime{#1}}
\def\endtime#1{\gdef\@endtime{#1}}
\def\nextdate#1{\gdef\@nextdate{#1}}
\def\nextplace#1{\gdef\@nextplace{#1}}
\def\nexttime#1{\gdef\@nexttime{#1}}
\def\@groupname{\ClassWarning{protocol}{No \noexpand\groupname given}}
\def\@chair{\ClassWarning{protocol}{No \noexpand\chair given}}
\def\@writer{\ClassWarning{protocol}{No \noexpand\writer given}}
\gdef\@nextdate{\ClassWarning{protocol}{No \noexpand\nextdate given}}
\gdef\@nextplace{\ClassWarning{protocol}{No \noexpand\nextplace given}}
\gdef\@nexttime{\ClassWarning{protocol}{No \noexpand\nexttime given}}
\gdef\@begintime{\ClassWarning{protocol}{No \noexpand\beginn given}}
\gdef\@endtime{\ClassWarning{protocol}{No \noexpand\endtime given}}
\newcommand\makehead{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \newpage
    \global\@topnum\z@   % Prevents figures from going at top of page.
    \@makehead
    \thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
  \global\let\makehead\relax
  \global\let\@makehead\relax
  \global\let\chairman\relax
  \global\let\@chair\@empty
  \global\let\writer\relax
  \global\let\@writer\@empty
  \global\let\begintime\relax
  \global\let\@begintime\@empty
  \global\let\endtime\relax
  \global\let\@endtime\@empty
  \global\let\groupname\relax
  \global\let\@groupname\@empty
}
\def\@makehead{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}%
  \let \footnote \thanks
    {\LARGE \@groupname \par}%
    \vskip 1.5em%
    {\large Protokoll der Sitzung vom \@date}%
    \vskip 1em%
    {\large
      \lineskip .5em%
       Sitzungsleitung: \@chair\\
       Protokollf\"uhrer: \@writer \par}%
  \end{center}%
  \par
  \vskip 1.5em
  \vskip 0.5cm{\noindent
    \begin{tabular}{ll}
      Beginn: & \@begintime\ Uhr \\
      Ende: &   \@endtime\ Uhr \\
    \end{tabular}\par}\vskip 0.5cm}
\newcommand{\@makefoot}{\ifx\nextdate\empty
      \section*{N\"achste Sitzung} Die n\"achste Sitzung
  findet am \@nextdate\ um \@nexttime\ Uhr statt. Ort:~\@nextplace.
  \else
      \section*{N\"achste Sitzung}
      Es wurde keine n\"achste Sitzung vereinbart
  \fi}
\newenvironment{Persons}{\section*{Anwesenheit:}}{}
\AtBeginDocument{\makehead}
\AtEndDocument{\@makefoot}
\parindent 0ex
\parskip 1.5ex
\endinput
%%
%% End of file `protocol.cls'.
