%%
%% This is file `pst-3dplot.pro',
%%
%% IMPORTANT NOTICE:
%%
%% Package `pst-3dplot.tex'
%%
%% Herbert Voss <voss _at_ PSTricks.de>
%%
%% This program can be redistributed and/or modified under the terms
%% of the LaTeX Project Public License Distributed from CTAN archives
%% in directory macros/latex/base/lppl.txt.
%%
%% DESCRIPTION:
%%   `pst-3dplot' is a PSTricks package to draw 3d curves and graphical objects
%%
%%
%% version 0.2 / 2005-01-14  Herbert Voss <voss _at_ PSTricks.de>
%
/tx@3DPlotDict 40 dict def
tx@3DPlotDict begin
%
/saveCoor { 
  dzUnit mul /z exch def
  dyUnit mul /y exch def
  dxUnit mul /x exch def
} def
%
/ConvertTo2D {
  RotatePoint
  /x2D x neg Alpha cos mul y Alpha sin mul add def
  /y2D x Alpha sin mul y Alpha cos mul add neg Beta sin mul z Beta cos mul add def
} def
%
/ConvertToCartesian {
  /latitude exch def
  /longitude exch def
  /Radius exch def
  /z { Radius latitude sin mul } def
  /x { Radius longitude cos mul latitude cos mul } def
  /y { Radius longitude sin mul latitude cos mul } def
} def
%
/SphericalTo2D {
  x y z ConvertToCartesian ConvertTo2D
} def
%
/convertStackTo2D {
  counttomark
  /n exch def /n3 n 3 div cvi def
  n3 {
    n -3 roll
    SphericalCoor { ConvertToCartesian } { saveCoor } ifelse
    ConvertTo2D
    x2D xUnit y2D yUnit
    /n n 1 sub def
  } repeat
} def
%
/CalcCoordinates {% from pst-vue3d
    formulesTroisD
    Xi 28.45 mul Yi 28.45 mul
} def
% pour la 3D conventionnelle
/DScreen 1 def
/Dobs 0 def
/formulesTroisD{%
  /xObservateur x Sin1 mul neg y Cos1 mul add def
  /yObservateur x Cos1Sin2 mul neg y Sin1Sin2 mul sub z Cos2 mul add def
  /zObservateur x neg Cos1Cos2 mul y Sin1Cos2 mul sub z Sin2 mul sub Dobs add def
  /Xi DScreen xObservateur mul zObservateur div def
  /Yi DScreen yObservateur mul zObservateur div def
} def
%
/RotatePointXYZ{% Mxx are defined in the TeX file
  /xi M11 x mul M12 y mul add M13 z mul add def
  /yi M21 x mul M22 y mul add M23 z mul add def
  /zi M31 x mul M32 y mul add M33 z mul add def
  /x xi def
  /y yi def
  /z zi def
} def
%
/RotXaxis { 
  /yTemp y RotX cos mul z RotX sin mul sub def
  /z  y RotX sin mul z RotX cos mul add def
  /y yTemp def
} def
/RotYaxis { 
  /xTemp x RotY cos mul z RotY sin mul add def
  /z  x RotY sin mul neg z RotY cos mul add def
  /x xTemp def
} def
/RotZaxis { 
  /xTemp x RotZ cos mul y RotZ sin mul sub def
  /y  x RotZ sin mul y RotZ cos mul add def
  /x xTemp def
} def
/xyz { RotXaxis RotYaxis RotZaxis } def
/yxz { RotYaxis RotXaxis RotZaxis } def
/yzx { RotYaxis RotZaxis RotXaxis } def
/xzy { RotXaxis RotZaxis RotYaxis } def
/zxy { RotZaxis RotXaxis RotYaxis } def
/zyx { RotZaxis RotYaxis RotXaxis } def
%
/RotatePoint { RotSequence cvx exec } def
%
end
