<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0"
  xmlns="http://www.w3.org/TR/xhtml1/transitional"
  exclude-result-prefixes="#default">

  <!-- $Id: tex-refs-chunk.xsl 142 2004-10-24 15:13:24Z mw $ -->

  <!-- FIXME: XHTML -->
  <!-- <xsl:import href="file:///home/mw/docbook-xsl/html/chunk.xsl"/> -->
  <!-- we use an XML catalog to resolve this file -->
  <xsl:import href="http://docbook.sourceforge.net/release/xsl/current/html/chunk.xsl"/>

  <!-- import common customizations -->
  <xsl:import href="tex-refs-common.xsl"/>

  <!-- insert customization here -->

  <xsl:param name="default.encoding" select="'ISO-8859-1'"/>

  <xsl:param name="use.id.as.filename" select="'1'"/>
  <xsl:param name="section.autolabel"  select="1"/>
  <xsl:param name="html.stylesheet"    select="'../tex-refs.css'"/>

  <!-- chunking options -->
  <xsl:param name="chunk.fast" select="1"/>

  <!-- Chunk the first top-level section? -->
  <xsl:param name="chunk.first.sections" select="0"/>

  <!-- Depth to which sections should be chunked  -->
  <xsl:param name="chunk.section.depth" select="1"/>

  <xsl:param name="process.source.toc">1</xsl:param>

  <!-- How deep should recursive sections appear in the TOC? -->
  <xsl:param name="toc.section.depth">2</xsl:param>

  <!-- Control depth of TOC generation in sections -->
  <xsl:param name="generate.section.toc.level" select="2"/>

  <xsl:param name="section.label.includes.component.label" select="1"/>

  <xsl:param name="chunker.output.method" select="'html'"/>

  <!-- no titles in headers and footers  -->
  <!--<xsl:param name="navig.showtitles" select="0"/> -->

  <!-- exchange header -->
  <xsl:template name="header.navigation">
    <xsl:param name="prev" select="/foo"/>
    <xsl:param name="next" select="/foo"/>
    <xsl:param name="nav.context"/>

    <xsl:variable name="home" select="/*[1]"/>
    <xsl:variable name="up" select="parent::*"/>

    <xsl:variable name="row1" select="$navig.showtitles != 0"/>
    <xsl:variable name="row2" select="count($prev) &gt; 0
                                      or (count($up) &gt; 0
                                      and generate-id($up) != generate-id($home)
                                      and $navig.showtitles != 0)
                                      or count($next) &gt; 0"/>

    <xsl:if test="$suppress.navigation = '0' and $suppress.header.navigation = '0'">
      <div class="navheader">
        <xsl:if test="$row1 or $row2">
          <table width="100%" summary="Navigation header">
            <xsl:if test="$row1">
              <tr>
               <th colspan="3" align="center">
                 <xsl:choose>
                    <xsl:when test="count($up) > 0
                       and generate-id($up) != generate-id($home) and $navig.showtitles != 0">
                      <xsl:apply-templates select="$up" mode="object.title.markup"/>
                    </xsl:when>
                    <xsl:otherwise>&#160;</xsl:otherwise>
                  </xsl:choose>
                </th>
              </tr>
            </xsl:if>

            <xsl:if test="$row2">
              <tr>
                <td width="20%" align="left">
                  <xsl:if test="count($prev)>0">
                    <a accesskey="p">
                      <xsl:attribute name="href">
                        <xsl:call-template name="href.target">
                          <xsl:with-param name="object" select="$prev"/>
                        </xsl:call-template>
                      </xsl:attribute>
                      <xsl:call-template name="navig.content">
                        <xsl:with-param name="direction" select="'prev'"/>
                      </xsl:call-template>
                    </a>
                  </xsl:if>
                  <xsl:text>&#160;</xsl:text>
                </td>
                <th width="60%" align="center">
                  <xsl:apply-templates select="." mode="object.title.markup"/>
                </th>
                <td width="20%" align="right">
                  <xsl:text>&#160;</xsl:text>
                  <xsl:if test="count($next)>0">
                    <a accesskey="n">
                      <xsl:attribute name="href">
                        <xsl:call-template name="href.target">
                          <xsl:with-param name="object" select="$next"/>
                        </xsl:call-template>
                      </xsl:attribute>
                      <xsl:call-template name="navig.content">
                        <xsl:with-param name="direction" select="'next'"/>
                      </xsl:call-template>
                    </a>
                  </xsl:if>
                </td>
              </tr>
            </xsl:if>
          </table>
        </xsl:if>
        <xsl:if test="$header.rule != 0">
          <hr/>
        </xsl:if>
      </div>
    </xsl:if>
  </xsl:template>

  <!-- FIXME: XHTML
  <xsl:param name="chunker.output.doctype-public" 
    select="'-//W3C//DTD XHTML 4.01 Transitional//EN'"/>
  <xsl:param name="chunker.output.doctype-system" 
    select="'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'"/>
  -->

  <!-- this enables generation of TOC in appendix
  <xsl:param name="generate.toc">
appendix  toc
article/appendix  toc
article   toc
book      toc,title,figure,table,example,equation
sect1     toc
sect2     toc
sect3     toc
sect4     toc
sect5     toc
section   toc
  </xsl:param>
 -->

</xsl:stylesheet>
