
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : init-eukleides.scm
;; DESCRIPTION : Initialize Eukleides plugin
;; COPYRIGHT   : (C) 2003 Joris van der Hoeven.
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (eukleides-serialize lan t)
  (import-from (texmacs plugin plugin-cmd))
  (with u (pre-serialize lan t)
    (with s (texmacs->verbatim (object->tree u))
      (string-append (escape-verbatim (string-replace s "\n" "~")) "\n"))))

(plugin-configure eukleides
  (:require (url-exists-in-path? "eukleides"))
  (:launch "tm_eukleides --texmacs")
  (:serializer ,eukleides-serialize)
  (:session "Eukleides"))
