
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : cm-fonts.scm
;; DESCRIPTION : setup cm fonts for text mode
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(texmacs-module (fonts fonts-cm))

(set-font-rules
  '(((cmacc rm medium right $s $d) (cm cmr $s $d))
    ((cmacc rm medium slanted $s $d) (cm cmsl $s $d))
    ((cmacc rm medium italic $s $d) (cm cmti $s $d))
    ((cmacc rm medium left-slanted $s $d) (cm cmff $s $d))
    ((cmacc rm medium small-caps $s $d) (cm cmcsc $s $d))
    ((cmacc rm medium slanted-small-caps $s $d) (cm cmcscsl $s $d))
    ((cmacc rm medium long $s $d) (cm cmdunh $s $d))
    ((cmacc rm medium italic-right $s $d) (cm cmu $s $d))
    ((cmacc rm bold right $s $d) (cm cmbx $s $d))
    ((cmacc rm bold slanted $s $d) (cm cmbxsl $s $d))
    ((cmacc rm bold italic $s $d) (cm cmbxti $s $d))
    ((cmacc rm bold condensed $s $d) (cm cmbom $s $d))
    ((cmacc rm bold small-caps $s $d) (cm cmbcsc $s $d))
    ((cmacc tt light right $s $d) (cm cmtl $s $d))
    ((cmacc tt light slanted $s $d) (cm cmsltl $s $d))
    ((cmacc tt medium right $s $d) (cm cmtt $s $d))
    ((cmacc tt medium slanted $s $d) (cm cmsltt $s $d))
    ((cmacc tt medium italic $s $d) (cm cmitt $s $d))
    ((cmacc tt medium small-caps $s $d) (cm cmtcsc $s $d))
    ((cmacc tt medium proportional $s $d) (cm cmvtt $s $d))
    ((cmacc tt bold right $s $d) (cm cmttb $s $d))
    ((cmacc ss light right $s $d) (cm cmbr $s $d))
    ((cmacc ss light slanted $s $d) (cm cmbrsl $s $d))
    ((cmacc ss medium right $s $d) (cm cmss $s $d))
    ((cmacc ss medium slanted $s $d) (cm cmssi $s $d))
    ((cmacc ss medium italic $s $d) (cm cmssi $s $d))
    ((cmacc ss medium flat $s $d) (cm cmssq $s $d))
    ((cmacc ss medium flat-italic $s $d) (cm cmssqi $s $d))
    ((cmacc ss bold right $s $d) (cm cmssbx $s $d))
    ((cmacc ss bold condensed $s $d) (cm cmssdc $s $d))
    ((cmacc $a medium right $s $d) (cmacc rm medium right $s $d))
    ((cmacc $a $b right $s $d) (cmacc $a medium right $s $d))
    ((cmacc $a $b $c $s $d) (cmacc $a $b right $s $d))

    ((pl rm medium slanted $s $d) (tex plsl $s $d))
    ((pl rm medium italic $s $d) (tex plti $s $d))
    ((pl rm medium $c $s $d) (tex plr $s $d))
    ((pl rm bold $c slanted $d) (tex plbxsl $s $d))
    ((pl rm bold $c italic $d) (tex plbxti $s $d))
    ((pl rm bold $c $s $d) (tex plbx $s $d))
    ((pl ss medium slanted $s $d) (tex plssq $s $d))
    ((pl ss medium italic $s $d) (tex plssi $s $d))
    ((pl ss medium $c $s $d) (tex plss $s $d))
    ((pl ss bold $c italic $d) (tex plssbi $s $d))
    ((pl ss bold $c $s $d) (tex plssbx $s $d))
    ((pl tt $b $c $s $d) (tex pltt $s $d))

    ((cmsy $a medium $c $s $d) (tex cmsy $s $d))
    ((cmsy $a bold $c $s $d) (tex cmbsy $s $d))
    ((cmmi $a medium $c $s $d) (tex cmmi $s $d))
    ((cmmi $a bold $c $s $d) (tex cmmib $s $d))
    ((cmtt $a medium $c $s $d) (tex cmtt $s $d))
    ((cmtt $a bold $c $s $d) (tex cmttb $s $d))

    ((roman rm $b $c $s $d)
     (compound
       (cork-cmacc (cmacc rm $b $c $s $d))
       (cork-cmsy (cmsy rm $b $c $s $d))
       (cork-cmmi (cmmi rm $b $c $s $d))
       (cork-cmtt (cmtt rm $b $c $s $d))
       (cork-pl (pl rm $b $c $s $d))))
    ((roman ss $b $c $s $d)
     (compound
       (cork-cmacc (cmacc ss $b $c $s $d))
       (cork-cmsy (cmsy ss $b $c $s $d))
       (cork-cmmi (cmmi ss $b $c $s $d))
       (cork-cmtt (cmtt ss $b $c $s $d))
       (cork-pl (pl ss $b $c $s $d))))
    ((roman tt $b $c $s $d)
     (compound
       (cork-cmtacc (cmacc tt $b $c $s $d))
       (cork-pl (pl tt $b $c $s $d))))

    ((concrete rm medium right $s $d) (cm ccr $s $d))
    ((concrete rm medium slanted $s $d) (cm ccsl $s $d))
    ((concrete rm medium italic $s $d) (cm ccti $s $d))
    ((concrete rm light slanted $s $d) (cm ccslc $s $d 9))
    ((concrete rm medium small-caps $s $d) (cm cccsc $s $d))
    ((concrete rm bold right $s $d) (cm cmbx $s $d))
    ((concrete rm bold slanted $s $d) (cm cmbxsl $s $d))
    ((concrete rm bold italic $s $d) (cm cmbxti $s $d))
    ((concrete rm bold condensed $s $d) (cm cmbom $s $d))
    ((concrete tt $a right $s $d) (cm cmtt $s $d))
    ((concrete tt $a slanted $s $d) (cm cmsltt $s $d))
    ((concrete tt $a italic $s $d) (cm cmitt $s $d))
    ((concrete tt medium small-caps $s $d) (cm cmtcsc $s $d))
    ((concrete tt $a proportional $s $d) (cm cmvtt $s $d))
    ((concrete ss medium right $s $d) (cm cmss $s $d))
    ((concrete ss medium slanted $s $d) (cm cmssi $s $d))
    ((concrete ss medium italic $s $d) (cm cmssi $s $d))
    ((concrete ss bold right $s $d) (cm cmbx $s $d))
    ((concrete ss bold condensed $s $d) (cm cmssdc $s $d))

    ((pandora rm medium right $s $d) (cm pnr $s $d))
    ((pandora rm medium slanted $s $d) (cm pnsl $s $d))
    ((pandora rm medium italic $s $d) (cm pnsl $s $d))
    ((pandora rm bold right $s $d) (cm pnb $s $d))
    ((pandora tt $a right $s $d) (cm pntt $s $d 9))
    ((pandora ss medium right $s $d) (cm pnss $s $d))
    ((pandora ss medium slanted $s $d) (cm pnssi $s $d))
    ((pandora ss medium italic $s $d) (cm pnssi $s $d))
    ((pandora ss bold right $s $d) (cm pnssb $s $d))

    ((duerer rm medium right $s $d) (tex cdr $s $d))
    ((duerer rm medium slanted $s $d) (tex cdsl $s $d))
    ((duerer rm medium italic $s $d) (tex cdi $s $d))
    ((duerer rm bold right $s $d) (tex cdb $s $d))
    ((duerer tt $a right $s $d) (tex cdtt $s $d))
    ((duerer ss medium right $s $d) (tex cdss $s $d))

    ((calligraphic $a medium $b $s $d) (tex callig $s $d 15))
    ((capbas $a medium $b $s $d) (tex capbas $s $d 0))
    ((hershey $a medium $b $s $d) (tex hscs $s $d))
    ((la $a medium $b $s $d) (tex la $s $d 14))
    ((messy $a medium $b $s $d) (tex cmfi $s $d))
    ((optical $a medium $b $s $d) (tex ocr $s $d))
    ((pacioli $a medium right $s $d) (tex cpcr $s $d))
    ((pacioli $a medium slanted $s $d) (tex cpcsl $s $d))
    ((punk $a medium right $s $d) (cm punk $s $d 20))
    ((punk $a medium slanted $s $d) (cm punksl $s $d 20))
    ((punk $a bold $b $s $d) (cm punkbx $s $d 20))
    ((twcal $a $b $c $s $d) (tex twcal $s $d 14))
    ((va $a medium $b $s $d) (tex va $s $d 14))

    ((Euler rm medium $b $s $d) (tex eufm $s $d))
    ((Euler rm bold $b $s $d) (tex eufb $s $d))
    ((ENR rm medium $b $s $d) (tex eurm $s $d))
    ((ENR rm bold $b $s $d) (tex eurb $s $d))
    ((gothic $a $b $c $s $d) (tex ygoth $s $d 0))
    ((schwell $a $b $c $s $d) (tex schwell $s $d 0))
    ((suet $a $b $c $s $d) (tex suet $s $d 14))
    ((swab $a $b $c $s $d) (tex yswab $s $d 0))
    ((blackletter $a $b $c $s $d) (tex blackletter $s $d 0))
    ((old-english $a $b $c $s $d) (tex hge $s $d 0))))
