/***************************************************************************
                             rmevent.h
                             -------------------
    begin                : May 2001
    copyright            : (C) 2001 by Jorge Allyson Azevedo
                                       Milena Scanferla
                                       Magnos Martinello
                                       Daniel Sadoc
    email                : {allyson,milena,magnos,sadoc}@land.ufrj.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef RMEVENT_H
#define RMEVENT_H

#include <string.h>
 
#include "rmstruct.h"

#define NAK_SND_WAIT 1    /* Waiting to send a NAK */
#define RET_RCV_WAIT 2    /* Waiting to receive a retransmission */
#define RET_SND_WAIT 3    /* Waiting to send a retransmission */
#define REF_SND_WAIT 4    /* Waiting to send a refresh message */

void eventListInit(EVENT_LIST **el);
int eventListAllocNode(EVENT_LIST **el_node, MEMBER_ID *member, char action, int sn, long timer_value);
int  eventListInsert(EVENT_LIST **el, MEMBER_ID *member_id, char action, int sn);
void eventListShow(EVENT_LIST *el);
int eventListRemove(EVENT_LIST **el, MEMBER_ID *member_id, char action, int sn);
int eventListRemoveFirst(EVENT_LIST **el);
EVENT_LIST * eventListFind(EVENT_LIST **el,MEMBER_ID *member_id, char action, int sn, EVENT_LIST **antNode);
int eventListIsEqual(EVENT_LIST *node1, EVENT_LIST *node2);

float generateSample(char distribution);
int generateTimerValue(char action, char distribution);

void setTimerValue(struct itimerval *value, long int time);
long double getTimerValue(/* struct itimerval *value */ struct timeval *value);

#endif
