/***************************************************************************
                             rmwinmask.h
                             -------------------
    begin                : Feb 2002
    copyright            : (C) 2002 by Jorge Allyson Azevedo
                                       Milena Scanferla
                                       Daniel Sadoc
    email                : {allyson,milena,sadoc}@land.ufrj.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _RMWINMASK_H

#define _RMWINMASK_H

#include "rmcache.h"
#include "rminternals.h"
#include "rmstruct.h"

#include <pthread.h>
#include <string.h>
#include <signal.h>
#include <errno.h>

#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>



extern pthread_mutex_t nak_window_mask_mutex;

/*********************** Routines to handle the window nack mask ************************************/


#define min(a,b)  ( ( (a)<(b))?a:b ) 

#define MAX_WINDOW_SIZE 64

int window_mask_get_bit2(int *window_mask, int position);

int window_mask_sn_within_window(int *window_mask, int sn, MEMBER_STATUS *mstatus);

int window_mask_get_bit(int *window_mask, int sn, MEMBER_STATUS *mstatus);


int window_mask_set_bit2(int *window_mask, int position, int value);



int window_mask_set_bit(int *window_mask, int sn, MEMBER_STATUS *mstatus, int value);


int window_mask_numbers2array(int *window_mask, int  hmask, int  lmask);

int window_mask_array2numbers(int *window_mask, int *hmask, int *lmask, int mask_ini);

#define SHOW    for( i = MAX_WINDOW_SIZE - 1; i >= 0 ; i--) \
    {\
        fprintf(stderr,"%d",    c->sm_info.member_status.window_mask[ i ] );\
        if ( i ==  c->sm_info.member_status.window_ini )\
            fprintf ( stderr, "}" );\
        if ( i ==  c->sm_info.member_status.window_ini + c->sm_info.member_status.window_size ) \
            fprintf ( stderr, "{" );        \
    }\
    fprintf(stderr,"\n");


#endif
