/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2007 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef MYASSERT_SEEN
    #define MYASSERT_SEEN
    
    #ifdef NDEBUG
        #define myassert(e)   ((void)0)
    #else
    
        #include <stdlib.h>
    
        #define myassert(e)  \
            ((void) ((e) ? 0 : __myassert (#e, __FILE__, __LINE__, __func__)))
        #define __myassert(e, file, line, function) \
            ((void)printf ("\n%s:%u: failed assertion `%s'\nin function `%s'\n\n", file, line, e, function), abort(), 0)
    
    #endif
#endif
