/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2008 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef FRAGCOORDS_SEEN
#define FRAGCOORDS_SEEN

typedef struct FragCoords_
{
    int             fraglen;   /* number of coordinates */
    double         *x, *y, *z; /* x,y,z atomic coordinates */
    double         *w;         /* weight = o/b */
    double         *var;
    double          center[3]; /* centroid of coordinates */
} FragCoords;

FragCoords
*FragCoordsAlloc(int fraglen);

void
FragCoordsFree(FragCoords *frag);

void
CenterFrag(FragCoords *frag);

void
CenterFragCA(FragCoords *frag);

double
DiffDist(FragCoords *frag1, FragCoords *frag2, double **distmat1, double **distmat2);

double
SqrFragCoordsDist(FragCoords *coords1, int atom1, FragCoords *coords2, int atom2);

double
RadGyrSqrFrag(const FragCoords *frag);

void
PrintFragCoords(FragCoords *coords);

#endif
