/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2008 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PDBCOORDS_SEEN
#define PDBCOORDS_SEEN

#include "DLTmath.h"
#include "msa.h"
#include "Coords.h"


/* A structure for mapping sequence names in an alignment to their corresponding
   pdbfiles */
typedef struct Seq_2_PDB
{
    int             seqnum;
    char          **pdbfile_name;
    char          **seqname;

    char           *pdbfile_name_space;
    char           *seqname_space;

    int            *map;
    MSA            *msa;
} Seq2PDB;


/* PDBCoords is mostly for reading/writing PDB files */
typedef struct PDB_Coords
{
    char            filename[FILENAME_MAX];
    int             model;
    double        **matrix;
    double         *translation;
    int             vlen; /* number of coordinates */

    /* PDB ATOM/HETATM fields */
    char          **record; /* ATOM or HETATM */
    unsigned int   *serial; /* atom number */
    char           *Hnum;
    char          **name; /* atom name, e.g. CA */
    char           *altLoc; /* alternate location identifier, usu A, B, or C */
    char          **resName; /* residue name, e.g. ALA, TYR, PHE, etc. */
    char           *xchainID;
    char           *chainID;
    int            *resSeq; /* residue number */
    char           *iCode;
    double         *x; /* x,y,z atomic coordinates */
    double         *y;
    double         *z;
    double         *occupancy;
    double         *tempFactor; /* B-factor */
    char          **segID;
    char          **element;
    char          **charge;

    /* not to be accessed - for space only */
    char           *record_space;
    char           *name_space;
    char           *resName_space;
    char           *segID_space;
    char           *element_space;
    char           *charge_space;
} PDBCoords;


typedef struct PDB_Coords_Array
{
    PDBCoords     **coords;     /* pointer to an array of cnum pointers to Coords */
    PDBCoords      *avecoords;  /* average Coords of all in CoordsArray */
    struct Coords_Array    *cdsA;       /* associated CoordsArray - do not free */
    struct Coords_Array    *scratchA;   /* do not free */
    int             vlen;       /* number of coordinates */
    int             cnum;       /* number of Coords in array */
    int            *upper, *lower;
    int             range_num;
    Seq2PDB        *seq2pdb;
} PDBCoordsArray;

#endif
