/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2009 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef HIERARCHVARS_SEEN
#define HIERARCHVARS_SEEN

#include "pdbMalloc.h"

void
InvgaussFitVars(CoordsArray *cdsA, double *mean, double *lambda);

void
InvgaussAdjustVars(CoordsArray *cdsA,
                   const double mean, const double lambda);

void
LognormalFitVars(CoordsArray *cdsA, double *zeta, double *sigma);

void
LognormalAdjustVars(CoordsArray *cdsA, double zeta, double sigma);

void
InvGammaFitVars(CoordsArray *cdsA, int iterate);

void
ConjBayesAdjustVar(double *newvar, const double *var, const int vlen, const int cnum, const double phi);

void
WishartAdjustVar(double *newvar, const double *var, const int vlen, const int cnum, const double phi);

void
WishartAdjustVar2(double *newvar, const double *var, const int vlen, const int cnum, const double phi);

void
WishartFitVar(CoordsArray *cdsA, int iterate);

void
WishartFitVar2(CoordsArray *cdsA, int iterate);

void
InvGammaFitEvals(CoordsArray *cdsA, int iterate);

void
InvGammaFitEvalsNoN(CoordsArray *cdsA, int iterate);

void
InvGammaFitModeEvals(CoordsArray *cdsA, int iterate);

void
InvGammaBayesFitEvals(CoordsArray *cdsA, int iterate);

void
InvGammaFitEvalsBfact(CoordsArray *cdsA, int iterate);

void
InvGammaFitEvals3(CoordsArray *cdsA, int iterate);

void
InvGammaBayesFitEvals3(CoordsArray *cdsA, int iterate);

void
InvGammaFitEvalsEq(CoordsArray *cdsA, int iterate);

void
InvGammaFitEvals2(CoordsArray *cdsA, int iterate);

void
InvGamma1FitEvals(CoordsArray *cdsA, int iterate);

void
InvGammaFitVarsND(CoordsArray *cdsA, int iterate);

void
InvGammaFitVars_minc(CoordsArray *cdsA, const double minc, int iterate);

void
InvGammaFitVars_fixed_c(CoordsArray *cdsA, const double c, int iterate);

void
InvGammaMLFixedCFitEvals(CoordsArray *cdsA, const double c, int iterate);

void
InvGammaEMFixedCFitEvals(CoordsArray *cdsA, const double c, int iterate);

void
InvGammaMLFitEvals(CoordsArray *cdsA, int iterate);

void
InvGammaBayesFitVars_fixed_c(CoordsArray *cdsA, const double c, int iterate);

void
InvGammaFitVars_GaussVarVar(CoordsArray *cdsA, double *b, double *c);

void
InvGammaFitVars_Mode(CoordsArray *cdsA, double *b, double *c, const double mode);

void
InvGammaStacyFitVars(CoordsArray *cdsA, double *b, double *c);

void
InvGammaMMFitVars(CoordsArray *cdsA, double *b, double *c);

void
InvGammaAdjustVars(CoordsArray *cdsA, const double b, const double c);

void
InvGammaAdjustCov(CoordsArray *cdsA, const double b, const double c);

void
InvGammaAdjustCovMode(CoordsArray *cdsA, const double b, const double c);

void
InvGammaAdjustCovND(CoordsArray *cdsA, const double b, const double c);

void
RecipInvGaussFitVars(CoordsArray *cdsA, double *mu, double *lambda);

void
RecipInvGaussAdjustVars(CoordsArray *cdsA,
                            const double mu, const double lambda);

#endif
