/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2013 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PDBUTILS_SEEN
#define PDBUTILS_SEEN

#include <pthread.h>
#include "pdbMalloc.h"
#include "Threads.h"

void
CdsCopyXYZ(Cds *cds1, const Cds *cds2);

void
CdsCopyAll(Cds *cds1, const Cds *cds2);

void
CdsDelete(CdsArray *cdsA, int omit);

void
CdsArrayCopy(CdsArray *cdsA1, const CdsArray *cdsA2);

void
AlgorithmCopy(Algorithm *algo1, const Algorithm *algo2);

void
StatisticsCopy(Statistics *stats1, const Statistics *stats2);

void
CdsCopy(Cds *cds1, const Cds *cds2);

void
PDBCdsCopyAll(PDBCds *cds1, const PDBCds *cds2);

void
CdsAdd(Cds *cds1, const Cds *cds2);

void
RotMatAddIp(double **mat1, const double **mat2);

void
CopyCds2PDB(PDBCds *pdbcds, const Cds *cds);

int
NMRCheckPDBCdsArray(PDBCdsArray *pdbA);

void
TransformPDBCdsIp(PDBCds *pdbcds);

void
RotateCdsIp(Cds *cds, const double **U);

void
RotateCdsArrayIp(CdsArray *cdsA, const double **rmat);

void
RotateCdsOp(const Cds *cds1, const double **U, Cds *cds2);

void
TransformCdsIp(Cds *cds);

void
ScaleCds(Cds *cds, const double scale);

double
NormalizeWeights(double *w, int vlen);

double
NormalizeWeightsOcc(double *w, double *o, int vlen);

void
UnityWeightsCdsArray(CdsArray *cdsA);

void
CenMass(Cds *cds);

void
CenMassWtOp(Cds *cds, const CdsArray *weights);

void
CenMassWtIp(Cds *cds, const double *weights);

void
CenMassCovOp(Cds *cds, const CdsArray *weights);

void
CenMassCov(Cds *cds, const double **wtmat);

void
CenMassWt(Cds *cds);

void
CenMassOccVec(Cds *cds, double *cenmass);

void
CenMassWtIpOcc(Cds *cds, const double *wts);

void
CenMassWtIpEM(Cds *cds, const Cds *avecds, const double *wts);

void
ApplyCenter(Cds *cds, const double cenx, const double ceny, const double cenz);

void
ApplyNegCenterIp(Cds *cds);

void
ApplyCenterIp(Cds *cds);

void
ApplyCenterOp(Cds *cds1, const Cds *cds2);

void
TransCdsIp(Cds *cds, const double *trans);

void
NegTransCdsIp(Cds *cds, const double *trans);

void
EM_MissingCds(CdsArray *cdsA);

void
AveCds_pth(CdsArray *cdsA, AveData **avedata, pthread_t *callThd,
              pthread_attr_t *attr, const int thrdnum);

double
HierAveCds(CdsArray *cdsA);

void
AveCds(CdsArray *cdsA);

void
AveCdsTB(CdsArray *cdsA, int omit);

void
AveCdsOcc(CdsArray *cdsA);

void
CalcCdsPrincAxes(Cds *cds, double **rotmat);

void
SumCdsTB(CdsArray *cdsA, const int exclude);

double
*ConcatQuatsIp(const double *quat1, double *quat2);

#endif
