/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2014 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef THESEUSLIB_SEEN
#define THESEUSLIB_SEEN

#include "Cds.h"

int
test_charmm(CdsArray *cdsA);

void
CalcS2(CdsArray *cdsA, const int nsell, double *bxij, double *byij, double *bzij, 
       double *rij, double *s2, const int whoiam);

int
theseuss2_(const double *xbuf, const double *ybuf, const double *zbuf,
           const int *natomx, const int *nensem, const int *nsell,
           double *bxij, double *byij, double *bzij,
           const int *il, const int *jl, double *rij, double *s2,
           const int *ls, const int *whoiam);

int
theseus_(double *xbuf, double *ybuf, double *zbuf, int *natomx, int *nensem, int *ls);

int
MultiPoseLib(CdsArray *cdsA);

#endif
