/***************************************************************************
                            th-disc-drive-pool.h
                            --------------------
    begin                : Tue Oct 12 2004
    copyright            : (C) 2004 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _th_disc_drive_pool_h_included_
#define _th_disc_drive_pool_h_included_

#include "th-disc-drive.h"

#define TH_TYPE_DISC_DRIVE_POOL            (th_disc_drive_pool_get_type())
#define TH_DISC_DRIVE_POOL(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj,  TH_TYPE_DISC_DRIVE_POOL, ThDiscDrivePool))
#define TH_DISC_DRIVE_POOL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass,   TH_TYPE_DISC_DRIVE_POOL, ThDiscDrivePoolClass))
#define TH_IS_DISC_DRIVE_POOL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj,  TH_TYPE_DISC_DRIVE_POOL))
#define TH_IS_DISC_DRIVE_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TH_TYPE_DISC_DRIVE_POOL))

typedef struct _ThDiscDrivePool        ThDiscDrivePool;
typedef struct _ThDiscDrivePoolClass   ThDiscDrivePoolClass;
typedef struct _ThDiscDrivePoolPrivate ThDiscDrivePoolPrivate;

struct _ThDiscDrivePool
{
	GObject object;
	
	ThDiscDrivePoolPrivate *priv;
};

struct _ThDiscDrivePoolClass
{
	GObjectClass  parent_class;

	void        (*drive_added)    (ThDiscDrivePool *cdpool, ThDiscDrive *drive);

	void        (*drive_removed)  (ThDiscDrivePool *cdpool, ThDiscDrive *drive);

	void        (*disc_changed)   (ThDiscDrivePool *cdpool, ThDiscDrive *drive);

	void        (*no_drive_found) (ThDiscDrivePool *cdpool);
};

/* functions */

GType                th_disc_drive_pool_get_type  (void) G_GNUC_CONST;

ThDiscDrivePool     *th_disc_drive_pool_new (void);

#endif /* _th_disc_drive_pool_h_included_ */

