/***************************************************************************
                             th-title-selector.h
                             -------------------
    begin                : Mon Nov 08 2004
    copyright            : (C) 2004 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _th_title_selector_h_included_
#define _th_title_selector_h_included_

#include "th-fake-dialog.h"

#define TH_TYPE_TITLE_SELECTOR             (th_title_selector_get_type())
#define TH_TITLE_SELECTOR(obj)             (G_TYPE_CHECK_INSTANCE_CAST (obj,  TH_TYPE_TITLE_SELECTOR, ThTitleSelector))
#define TH_TITLE_SELECTOR_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST (klass,   TH_TYPE_TITLE_SELECTOR, ThTitleSelectorClass))
#define TH_IS_TITLE_SELECTOR(obj)          (G_TYPE_CHECK_INSTANCE_TYPE (obj,  TH_TYPE_TITLE_SELECTOR))
#define TH_IS_TITLE_SELECTOR_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), TH_TYPE_TITLE_SELECTOR))

typedef struct _ThTitleSelector        ThTitleSelector;
typedef struct _ThTitleSelectorClass   ThTitleSelectorClass;
typedef struct _ThTitleSelectorPrivate ThTitleSelectorPrivate;

struct _ThTitleSelector
{
	ThFakeDialog  fake_dialog;
	
	ThTitleSelectorPrivate  *priv;
};

struct _ThTitleSelectorClass
{
	ThFakeDialogClass  fake_dialog_class;
};

/* functions */

GType            th_title_selector_get_type  (void) G_GNUC_CONST;

GtkWidget       *th_title_selector_new (void); 

GList           *th_title_selector_run (ThTitleSelector *ts); 

gboolean         th_title_selector_add_vob_folder (ThTitleSelector *ts, const gchar *dir); 

gboolean         th_title_selector_add_iso_file (ThTitleSelector *ts, const gchar *iso_fn);

#endif /* _th_title_selector_h_included_ */
