/* -*- mode: c; c-file-style: "gnu" -*-
 * daemon.h -- prototypes for the daemon-mode support functions
 * Copyright (C) 2002, 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file daemon.h
 * Daemon-mode support function prototypes.
 */

#ifndef _THY_DAEMON_H
#define _THY_DAEMON_H 1 /**< daemon.h multi-inclusion guard. */

#include "types.h"

thy_listener_t *daemon_init (void);
int daemon_select (thy_listener_t *listeners, long timeout);
int daemon_accept (thy_listener_t *listeners);
void daemon_handle_io (void);

#endif /* !_THY_DAEMON_H */
