/*
 *	TICKR - GTK-based Feed Reader - Copyright (C) Emmanuel Thomas-Maurin 2009-2012
 *	<manutm007@gmail.com>
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INC_TICKR_SOCKET_H
#define INC_TICKR_SOCKET_H

#define USE_PROXY_FLAG				get_use_proxy()
#define WARNING(a1, a2, a3, a4, a5, a6)		warning(a1, a2, a3, a4, a5, a6)
#define SOCK_OK					OK

/* check these 2 values - need more testing (1s / 0.5s / 0.1.s) */
#define SEND_RECV_TIMEOUT_SEC	1
#define SEND_RECV_TIMEOUT_USEC	0

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>
#include <ctype.h>
#include <fcntl.h>
#ifndef G_OS_WIN32
# include <grp.h>
# include <pwd.h>
# include <sys/socket.h>
# include <netdb.h>
# include <arpa/inet.h>
# include <sys/select.h>
#else
# define _WIN32_WINNT	0x0501	/* win version = xp or higher */
# include <winsock2.h>
# include <ws2tcpip.h>
# include <rpcdce.h>
# include <iphlpapi.h>
# include <winreg.h>
# include <shlobj.h>
#endif
#include "../libetm-0.4.3/libetm.h"

#define CONNECT_TIMEOUT		5
#define RECV_CHUNK_LEN		(16 * 1024 - 1)

#ifndef G_OS_WIN32
typedef int sockt;
# define SOCK_CREATE_ERROR	-1	/* socket() */
# define SOCK_FUNC_ERROR	-1	/* setsockopt(), bind(), listen(), select(), connect(),
					 * send(), recv(), fnctl(), ioctlsocket() */
# define CLOSE_SOCK(s)		close(s)
#else
typedef SOCKET sockt;
# define SOCK_CREATE_ERROR	INVALID_SOCKET
# define SOCK_FUNC_ERROR	SOCKET_ERROR
# define CLOSE_SOCK(s)		closesocket(s)
#endif

typedef enum {
	SOCK_ERROR = LIBETM_LASTERRORCODE + 1,
	SOCK_CANT_CONNECT,
	SOCK_SHOULD_BE_CLOSED,

	SELECT_ERROR,
	SELECT_TIMED_OUT,
	SELECT_TRUE,
	SELECT_FALSE,

	SEND_ERROR,
	RECV_ERROR,

	CONNECTION_CLOSED_BY_SERVER,

	SOCKET_LASTERRORCODE
} socket_error_code;

#define	FPRINTF_FFLUSH_2(a1, a2);		{fprintf(a1, a2);fflush(a1);}
#define	FPRINTF_FFLUSH_3(a1, a2, a3);		{fprintf(a1, a2, a3);fflush(a1);}
#define	FPRINTF_FFLUSH_4(a1, a2, a3, a4);	{fprintf(a1, a2, a3, a4);fflush(a1);}

/*
 * open stream socket in non-blocking mode and connect to host
 * return socket fd (> 0) / SOCK_CREATE_ERROR (-1 on Linux) if error
 */
sockt		connect_to_host(const char *, const char *);

int		writable_data_is_available_on_socket(sockt);

int		readable_data_is_available_on_socket(sockt);

/*
 * return n bytes sent or SOCK_FUNC_ERROR (-1 on Linux) if error (connection
 * closed by server or ?)
 */
int		send_full(sockt, const char *);

/*
 * return response = recv_full(socket, &bytes_received, &status) or NULL if error
 * -> status = SOCK_OK, CONNECTION_CLOSED_BY_SERVER, RECV_ERROR or SOCK_SHOULD_BE_CLOSED
 * -> allocate memory for response (must be freed afterwards with free2() if != NULL)
 */
char		*recv_full(sockt, int *, int *);

#ifdef G_OS_WIN32
const char	*win32_error_msg(int);
#endif

const char	*sock_error_message();
#endif /* INC_TICKR_SOCKET_H */
