/*
 *	libetm-0.4 / error.c - Copyright (C) Emmanuel Thomas-Maurin 2008-2012
 * 	<manutm007@gmail.com>
 *
 *	- Error handling -
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <stdio.h>
#include "libetm.h"

/*
 * Critical error handler for libetm that will call big_error() function
 * defined in app, so that appropiate behaviour can be choosen.
 */
int big_error_in_lib(lib_error_code error_code, const char *str)
{
	/* Only call big_error() in app */
	big_error(error_code, 4, LIBETM_NAME"-"LIBETM_VERSION_NUM": ", str, ": ", get_lib_error_str(error_code));
	return error_code;
}

const char *get_lib_error_str(lib_error_code error_code)
{
	/*
	 * *** Make sure this array matches the lib errors enum ***
	 */
	static char *lib_error_str[] = {
		"OK",
		"Out of memory",
		"Zero requested size",
		/*"Negative requested size",*/
		"Null destination string",
		"Source string = destination string",
		"Strings overlap",
		"Attempting to free a null pointer",
#ifdef WIN32_V
		"Can't find Win32 Registry Key",
		"Can't create Win32 Registry Key",
		"Can't save Win32 Registry Key",
		"Win32 Registry Key error (undetermined)",
#endif
		"OK"
	};

	if (error_code <= LIBETM_LASTERRORCODE)
		return (const char *)lib_error_str[error_code];
	else
		return "";
}
