#include "ImageCache.hpp"

using namespace indii::tint;

ImageCache::ImageCache(wxImage* image, const bool high) :
    original(image), high(high) {
  //
}

ImageCache::~ImageCache() {
  cache_t::iterator iter;
  for (iter = cache.begin(); iter != cache.end(); iter++) {
    delete iter->second;
  }
}

wxImage* ImageCache::get(const int width, const int height) {
  wxImage* image;
  
  if ((width == original->GetWidth() && height == original->GetHeight()) ||
      width <= 0 || height <= 0) {
    /* no need to resize, return original */
    image = original;
  } else {
    dim_t dim(width, height);
  
    cache_t::iterator find = cache.find(dim);
    if (find != cache.end()) {
      image = find->second;
    } else {
      int quality;
      if (high) {
        quality = wxIMAGE_QUALITY_HIGH;
      } else {
        quality = wxIMAGE_QUALITY_NORMAL;
      }
      image = new wxImage(original->Scale(width, height, quality));
      cache.insert(cache_pair_t(dim, image));
    }
  }
  return image;
}

