#ifndef INDII_TINT_GUI_THUMBPANE_HPP
#define INDII_TINT_GUI_THUMBPANE_HPP

#include "TintPane.hpp"
#include "ThumbImage.hpp"
#include "../ImageResource.hpp"
#include "../ClusterModel.hpp"
#include "../ClusterModelObserver.hpp"

#include "wx/scrolwin.h"
#include "wx/panel.h"

#include <vector>

namespace indii {
  namespace tint {
    namespace gui {
/**
 * Preview pane.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 74 $
 * @date $Date: 2009-03-02 14:59:56 +0900 (Mon, 02 Mar 2009) $
 */
class ThumbPane : public wxScrolledWindow, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param res Image resource.
   * @param model Cluster model.
   */
  ThumbPane(wxWindow* parent, ImageResource* res, ClusterModel* model);

  /**
   * Destructor.
   */
  ~ThumbPane();

  /**
   * Handle resize event.
   */
  void OnSize(wxSizeEvent& evt);

  /**
   * Handle number of clusters change.
   */
  virtual void notifyNumClustersChange();

private:
  /**
   * Image resources.
   */
  ImageResource* res;

  /**
   * Cluster model.
   */
  ClusterModel* model;

  /**
   * Thumbnails.
   */
  std::vector<ThumbImage*> thumbs;

  /**
   * Update layout.
   */
  void updateLayout();

  DECLARE_EVENT_TABLE()
  
};

    }
  }
}

#endif

