/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 363 $
 * $Date: 2012-01-22 18:45:43 +0800 (Sun, 22 Jan 2012) $
 */
#ifndef INDII_TINT_GUI_CHANNELMIXERPANE_HPP
#define INDII_TINT_GUI_CHANNELMIXERPANE_HPP

#include "Pane.hpp"
#include "../model/Model.hpp"
#include "../model/Observer.hpp"

#include "wx/slider.h"

namespace indii {
/**
 * Greyscale channel mixing pane.
 */
class ChannelMixerPane : public Pane, public Observer {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   */
  ChannelMixerPane(wxWindow* parent);

  /**
   * Set model.
   *
   * @param model Model.
   */
  void setModel(Model* model);

  /*
   * Handle model changes.
   */
  virtual void notifyGreyscaleChange();

  /*
   * Slider control events.
   */
  void OnSlideRed(wxScrollEvent& evt);
  void OnSlideGreen(wxScrollEvent& evt);
  void OnSlideBlue(wxScrollEvent& evt);

  /**
   * Context sensitive help.
   */
  void OnHelp(wxHelpEvent& evt);
  
private:
  /**
   * Model.
   */
  Model* model;

  /*
   * Slider controls.
   */ 
  wxSlider *slideRed, *slideGreen, *slideBlue;

  /*
   * Slider control ids.
   */
  enum ID {
    ID_SLIDE_RED,
    ID_SLIDE_GREEN,
    ID_SLIDE_BLUE
  };

  DECLARE_EVENT_TABLE()

};
}

#endif
