/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 363 $
 * $Date: 2012-01-22 18:45:43 +0800 (Sun, 22 Jan 2012) $
 */
#ifndef INDII_REG_COMPONENTS_HPP
#define INDII_REG_COMPONENTS_HPP

#include "wx/string.h"

namespace indii {
/**
 * Allows querying of installed components.
 */
class Components {
public:
  /**
   * Component ids.
   */
  enum Component {
    /**
     * Standalone app.
     */
    APP,
    
    /**
     * Plugin.
     */
    PLUGIN,

    /**
     * No. components.
     */
    NUM_COMPONENTS
    
  };
  
  /**
   * Is component activated?
   *
   * @param c The component.
   *
   * @return True if the component is activated, false otherwise.
   */
  static bool isActivated(const Component c);

  /**
   * Is commponent is trial period?
   *
   * @param c The component.
   *
   * @return True if the component is within its trial period, false
   * otherwise.
   */
  static bool isTrial(const Component c);

  /**
   * Are all components activated?
   *
   * @return True if all components are activated, false otherwise.
   */
  static bool allActivated();
  
  /**
   * Activate components.
   *
   * @param c Component in which the registration is taking place. Used to
   * tailor feedback to user.
   * @param key The activation key.
   *
   * @return True if the key is accepted, false otherwise.
   */
  static bool activate(const Component c, const wxString& key);
  
  /**
   * Get number of days left in trial period.
   *
   * @return Number of days left in trial period.
   */
  static int daysLeft();

};
}
 
#endif
