##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gtk
from gtk import glade
import gettext
import copy

import service
import rpc
import widget
import common
from modules.gui.window.win_search import win_search

def _form_read(name, value):
	res = rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'read', value[1], False, value[2])
	return res

def _template_get(name, value):
	if (len(value)==2) or (not value[2]):
		res = rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'fields_view_get', 0, value[1], rpc.session.context)
	else:
		view_id = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.ui.view', 'search', [('name','=',value[2])])
		res = rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'fields_view_get', view_id[0], value[1], rpc.session.context)
	return (res['fields'], res['model'], res['arch'])

def _many2one_sel(name, value):
	if len(value)==7:
		sel_multi = value[6]
	else:
		sel_multi = False
	ids = rpc.session.rpc_exec_auth('/object', 'execute', value[3], 'name_search', value[2], value[4])
	if len(ids)==1:
		return ids[0]
	res = rpc.session.rpc_exec_auth('/object', 'execute', value[3], 'fields_view_get', False, 'form', rpc.session.context)
	win = win_search(value[3], res, {'name':value[2]}, [], sel_multi=sel_multi, preload=True, ids=map(lambda x:x[0], ids), context=value[5])
	res = win.go()
	if res:
		res2 = rpc.session.rpc_exec_auth('/object', 'execute', value[3], 'name_get', res)
		if sel_multi:
			return res2
		return res2[0]
	return None

def _many2many_name_get(name, value):
	return rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'name_get', value[1])

def _many2one_name_get(name, value):
	name = rpc.session.rpc_exec_auth('/object', 'execute', value[1], 'name_get', [value[0]])
	if not len(name):
		return None
	return name[0]

def _char_selection(domain, args):
	res = rpc.session.rpc_exec_auth('/object', 'execute', args[0], 'distinct_field_get', args[1], args[2], domain)
	if len(res)>1:
		d = {}
		for x in res:
			d[x]=x
		res = common.selection(_('select field value:'), d)
		if res:
			return res[1]
		else:
			return None
	elif len(res)==1:
		return res[0]
	else:
		return None

def _default_get(name, value):
	return rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'default_get', value[1])

class dialog(object):
	def __init__(self, arch, fields, state, name):
		buttons = []
		self.states=[]
		for x in state:
			buttons.append(x[1])
			buttons.append(len(self.states))
			self.states.append(x[0])
		self.dia = gtk.Dialog('Tiny ERP', None,
			gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
			tuple(buttons))
		self.triggers = [('template_get', _template_get, None), 
			('name_id_get', _many2one_name_get, None),
			('form_read', _form_read, None),
			('names_get', _many2many_name_get, None),
			('many2one_sel', _many2one_sel, None),
			('default_get', _default_get, None)
			]

		self.form = widget.form(arch, fields, 'wizard.'+name, triggers = self.triggers)
		val = {}
		for f in fields:
			if 'value' in fields[f]:
				val[f] = fields[f]['value']
		self.form.value = val
		self.dia.vbox.pack_start(self.form.widget)
		self.dia.set_title(self.form.name)
		self.dia.show_all()

	def run(self, datas={}):
		while True:
			res = self.dia.run()
			if self.form.validate() or (self.states[res]=='end'):
				break
		if res<len(self.states) and res>=0:
			datas.update(self._filter_relation(self.form.value))
			self.dia.destroy()
			return (self.states[res], datas)
		else:
			self.dia.destroy()
			return False
	
	def _filter_relation(self, data):
		val = copy.copy(data)
		for key, value in val.items():
			if value and  self.form.fields.get(key, False) and self.form.fields[key]['type'] in ('many2one',):
				val[key] = val[key][0]
		return val

def execute(action, datas, state='init'):
	if not 'form' in datas:
		datas['form'] = {}
	wiz_id = rpc.session.rpc_exec_auth('/wizard', 'create', action)
	while state!='end':
			res = rpc.session.rpc_exec_auth('/wizard', 'execute', wiz_id, datas, state)
			if 'datas' in res:
				datas['form'].update( res['datas'] )
			if res['type']=='form':
				dia = dialog(res['arch'], res['fields'], res['state'], action)
				dia.form.value = datas['form']
				dia.form.state_set('valid')
				res = dia.run(datas['form'])
				if not res:
					break
				(state, new_data) = res
				for d in new_data:
					if new_data[d]==None:
						del new_data[d]
				datas['form'].update(new_data)
				del new_data
			elif res['type']=='action':
				obj = service.LocalService('action.main')
				obj._exec_action(res['action'],datas)
				state = res['state']
			elif res['type']=='print':
				obj = service.LocalService('action.main')
				datas['report_id'] = res.get('report_id', False)
				if res.get('get_id_from_action', False):
					backup_ids = datas['ids']
					datas['ids'] = datas['form']['ids']
					win = obj.exec_report(res['report'], datas)
					datas['ids'] = backup_ids
				else:
					win = obj.exec_report(res['report'], datas)
				state = res['state']
			elif res['type']=='state':
				state = res['state']
			#common.error('Wizard Error:'+ str(e.type), e.message, e.data)
			#state = 'end'

# vim:noexpandtab
