##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gtk
from gtk import glade

import common
import wid_common
import wid_int
import rpc


class char(wid_int.wid_int):
	def __init__(self, parent, attrs={}):
		self.win_gl = glade.XML(common.terp_path("terp.glade"),"widget_char")
		self.widget = self.win_gl.get_widget('widget_char')
		#self.widget = gtk.Entry(int(attrs.get('size',10)))
		self.widget.set_max_length(int(attrs.get('size',16)))
		self.widget.set_visibility(not attrs.get('invisible', False))
		wid_int.wid_int.__init__(self, parent, attrs)
		self.widget.set_has_frame(False)
		self.widget.set_width_chars(5)
		self.widget.connect('button_press_event', self._menu_open)
#		if attrs.get('select', False):
		self.widget.connect('activate', self.sig_activate)
		self.widget.connect('focus-in-event', lambda x,y: self._focus_in())
		self.widget.connect('focus-out-event', lambda x,y: self._focus_out())

	def _value_get(self):
		str = self.widget.get_text()
		if str=='':
			return False
		else:
			return str

	def _readonly_set(self, value):
		wid_int.wid_int._readonly_set(self, value)
		self.widget.set_editable(not value)
		self.widget.set_sensitive(not value)

	def sig_activate(self, widget=None):
		if self.attrs.get('select', False):
			res = self.trigger('char_selection', (self.model, self.name, self.value or ''))
			if res:
				self.value = res
		if self.attrs.get('on_change', False):
			self.on_change(self.attrs['on_change'])

	def _color_widget(self):
		return self.widget

	def _value_set(self, value):
		self.widget.set_text(value or '')

	value = property(_value_get, _value_set, None,
	  'The content of the widget or ValueError if not valid')
	value2 = property(_value_get, _value_set, None,
	  'The content of the widget or ValueError if not valid')

	def clear(self):
		self.value = ''

