##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import pygtk
pygtk.require('2.0')

import gtk
from gtk import glade

import wid_int
import form
import copy
import common


class one2many(wid_int.wid_int):
	def __init__(self, parent, attrs):
		wid_int.wid_int.__init__(self, parent, attrs)

		win_gl = glade.XML(common.terp_path("terp.glade"),"widget_one2many")
		win_gl.signal_connect('on_but_next_clicked', lambda x,y: self.page_next() )
		win_gl.signal_connect('on_but_previous_clicked', lambda x,y: self.page_previous() )
		win_gl.signal_connect('on_but_new_clicked', lambda x,y: self.page_new())
		win_gl.signal_connect('on_but_copy_clicked', lambda x,y: self.page_copy())
		win_gl.signal_connect('on_but_del_clicked', lambda x,y: self.page_del())


		self.label = win_gl.get_widget('one2many_label')
		title = win_gl.get_widget('one2many_title')
		title.set_label(attrs.get('string','Unknown Title'))
		#self.combo = win_gl.get_widget('widget_one2many_combo')
		#self.combo.entry.connect('activate', self.test)

		vbox = gtk.VBox(homogeneous=False, spacing=1)
		vbox.pack_start(win_gl.get_widget('widget_one2many'))

		if attrs.get('view_data_form'):
			res = attrs.get('view_data_form')
			(fields, model, xml) = (res['fields'], res['model'], res['arch'])
		else:
			(fields, model, xml) = self.trigger('template_get', (attrs['relation'],'form',attrs.get('view_form',False)))
		
		self.fields = fields
		self.form=form.form(xml, fields, model, parent=self)
		self.model = model
		vbox.pack_start(self.form.widget)
		self.widget = vbox
		self.clear()

	def test(*args):
		pass

	def page_reload(self):
		self.form.value = self.values[self.values_pos]
		#self.combo.set_popdown_strings([x['name'] or '' for x in self.values])
		#self.combo.entry.set_text(self.values[self.values_pos]['name'] or '')
		self.label.set_label('('+str(self.values_pos+1)+'/'+str(len(self.values))+')')

	def clear(self):
		self.form.clear()
		self.history = []
		self.values = [self.form.value]
		self.values[0]['id']=False
		self.values_pos = 0
		self.page_reload()
		self.modifs = {}

	def validate(self):
		return True
		if (self.constraint['required']) and (len(self.values)==0):
			return False
		return True

	def _page_save(self):
		id = self.values[self.values_pos].get('id', self.form.id)
		self.values[self.values_pos] = self.form.value
		self.values[self.values_pos]['id'] = id
		self.modifs[id]=True

	def page_copy(self):
		v = self.form.value
		self._page_save()
		self.form.value = v
		self.values.append(self.form.value)
		self.values[-1]['id'] = False
		self.values_pos = len(self.values)-1
		self.page_reload()


	def page_new(self):
		self._page_save()
		self.form.clear()
		self.values.append(self.form.value)
		self.values[-1]['id'] = False
		self.values_pos = len(self.values)-1
		self.page_reload()

	def page_previous(self):
		if self.values_pos>0:
			self._page_save()
			self.values_pos-=1
			self.page_reload()

	def page_next(self):
		if self.values_pos<len(self.values)-1:
			self._page_save()
			self.values_pos+=1
			self.page_reload()

	def page_del(self):
		if self.values[self.values_pos].get('id', False):
			self.history.append( self.values[self.values_pos]['id'] )
		del self.values[self.values_pos]
		if len(self.values)==0:
			self.form.clear()
			self.values.append(self.form.value)
			self.values[-1]['id'] = False
		if self.values_pos>0:
			self.values_pos-=1
		self.page_reload()

	def _value_get(self):
		self._page_save()
		res = []
		for id in self.history:
			res.append( (2, id, False) )
		for val in self.values:
			val2 = copy.copy(val)
			for key, value in val2.items():
				if value:
					if self.fields.get(key, None) and self.fields[key]['type'] in ('many2one',):
						val2[key] = val2[key][0]
			id = val2.get('id', False)
			if 'id' in val2:
				del val2['id']
			if id and (id in self.modifs):
				res.append( (1, id, val2) )
			elif not id:
				res.append( (0, False, val2) )
		return res

	def _value_set(self, value):
		self.clear()
		arg2 = self._context_get(self.parent)
		resources = self.trigger('form_read', (self.model, value, arg2))
		self.values = copy.copy(resources)
		if not len(self.values):
			self.clear()
		self.page_reload()

	value = property(_value_get, _value_set, None,
	  'The content of the form or excpetion if not valid')
	value2 = property(_value_get, _value_set, None,
	  'The content of the form or excpetion if not valid')

	
