##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# $Id: one2many_list.py 1937 2005-12-23 14:10:24Z pinky $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gobject
import gtk
from gtk import glade

import common
import wid_int
import wid_common
import widget
import service

import form
import copy

class dialog(object):
	def __init__(self, model, fields, arch, parent, state='Edition', value=None):
		win_gl = glade.XML(common.terp_path("terp.glade"),"dia_form_win_many2one")
		self.dia = win_gl.get_widget('dia_form_win_many2one')
		self.dia.set_title('Ressource '+state+': '+model)

		self.form = form.form(arch, fields, model, parent=parent)
		self.form.state_set('valid')
		self.value_set(value)
		self.fields = fields

		self.sw = win_gl.get_widget('many2one_vp')
		self.sw.add(self.form.widget)

		self.dia.set_title(self.form.name)
		self.dia.show_all()

	def value_set(self, value):
		if value:
			self.form.value = value

	def clear(self):
		self.form.clear()

	def run(self, datas={}):
		end = False
		while not end:
			res = self.dia.run()
			end = (res != gtk.RESPONSE_OK) or self.form.validate()
		if res==gtk.RESPONSE_OK:
			datas = self.form.value
			return (res==gtk.RESPONSE_OK, datas)
		return (False, False)

	def destroy(self):
		self.dia.destroy()


class one2many_list(wid_int.wid_int):
	def __init__(self, parent, attrs={}):
		wid_int.wid_int.__init__(self, parent, attrs)

		self.win_gl = glade.XML(common.terp_path("terp.glade"),"widget_one2many_list")
		self.win_gl.signal_connect('on_o2ml_but_new_pressed', self._sig_new )
		self.win_gl.signal_connect('on_o2ml_but_edit_pressed', self._sig_edit )
		self.win_gl.signal_connect('on_o2ml_but_delete_pressed', self._sig_remove )
		self.win_gl.signal_connect('on_o2ml_but_refresh_pressed', self._sig_refresh )
		self.win_gl.signal_connect('on_o2ml_but_sequence_clicked', self._sig_sequence )
		self.view = attrs.get('view', False)

		if attrs.get('view_data_tree'):
			res = attrs.get('view_data_tree')
			(fields, model, xml) = (res['fields'], res['model'], res['arch'])
		else:
			(fields, model, xml) = self.trigger('template_get', (attrs['relation'],'tree', attrs.get('view_tree',False) ))
		if attrs.get('view_data_form'):
			res = attrs.get('view_data_form')
			(self.fields_form, model, self.arch_form) = (res['fields'], res['model'], res['arch'])
		else:
			(self.fields_form, model, self.arch_form) = self.trigger('template_get', (model,'form', self.view) )

		self.tree_view = widget.tree(xml, fields, model, parent=parent)
		self.model = model
		self.tree_view.widget.connect('row-activated', self._sig_edit)
		
		self.tree_view.widget.connect('button_press_event', self._menu_open)

		self.widget = self.win_gl.get_widget('widget_one2many_list')
		wd = self.win_gl.get_widget('o2ml_sw')
		self.tree_view.widget.set_reorderable(True)
		wd.add(self.tree_view.widget)
		
		self.fields = fields
		seq_but = self.win_gl.get_widget('o2ml_but_sequence')
		seq_but.set_sensitive('sequence' in fields)

		self._menu_entries.append((None, None, None))
		self._menu_entries.append((_('Action'), lambda x: self.click_and_action('client_action_multi'),1))
		self._menu_entries.append((_('Report'), lambda x: self.click_and_action('client_print_multi'),1))

		self._value=[]
		self._history=[]
		self.modifs = {}

	def click_and_action(self, type):
		pos = self.tree_view.pos_get()
		if pos!=None:
			val = self._value[pos]
			id = val.get('id', False)
			obj = service.LocalService('action.main')
			res = obj.exec_keyword(type, {'model':self.model, 'id': id or False, 'ids':[id], 'report_type': 'pdf'})
			return True
		else:
			common.message(_('You have to select a ressource !'))
			return False

	def validate(self):
		return True

	def _readonly_set(self, value):
		wid_int.wid_int._readonly_set(self, value)
		self.win_gl.get_widget('o2ml_but_new').set_sensitive(not value)
		self.win_gl.get_widget('o2ml_but_delete').set_sensitive(not value)
		self.win_gl.get_widget('o2ml_but_edit').set_sensitive(not value)

	def _list_reload(self):
		self.tree_view.value = self._value

	def _sig_new(self, *args):
		val_def = self.trigger('default_get', (self.model,self.fields_form.keys()) )
		dia = dialog(self.model, self.fields_form, self.arch_form, self, state='Append')
		while True:
			dia.clear()
			dia.value_set(val_def)
			res = dia.run()
			if res and res[0]:
				self.tree_view.add_line(res[1])
			else:
				break
		dia.destroy()
		return True

	def _sig_edit(self, *args):
		pos = self.tree_view.pos_get()
		if pos!=None:
			val = self.tree_view.model[pos][0]
#			val = self._value[pos]
			id = val.get('id', False)
			dia = dialog(self.model, self.fields_form, self.arch_form, self)
			dia.value_set(val)
			res = dia.run()
			dia.destroy()
			if res:
				if res[0]:
					if id:
						res[1]['id']=id
					self.modifs[pos]=True
#					self._value[pos]=res[1]
					self.tree_view.model[pos][0].update(res[1])
					self.tree_view.model[pos][0]['__modified'].add(0)
					self.tree_view.refresh_row(pos, self.tree_view.model[pos][0])
		return True

	def _sig_remove(self, *args):
		pos = self.tree_view.pos_get()
		if pos!=None:
			if self._value[pos].get('id', False):
				self._history.append( self._value[pos]['id'] )
			del self._value[pos]
			self._list_reload()

	def _sig_refresh(self, *args):
		self._list_reload()

	def _sig_sequence(self, *args):
		model = self.tree_view.model
		order = [(10*(idx+1), int(item[0])) for idx, item in enumerate(iter(model))]
		for seq, pos in order:
			self._value[pos]['sequence'] = seq
			#self.modifs[pos]=True
		self._sig_refresh(args)

	def _value_set(self, value):
		self.modifs = {}
		self._value = []
		self._history = []

		arg2 = self._context_get(self.parent)
		if value and type(value[0]) == int:
			resources = self.trigger('form_read', (self.model, value, arg2))
			for r in resources:
				for k in r.keys():
					if r[k]=='':
						r[k] = False
			self.tree_view.add_line(r, modification=False)
			self._value = copy.copy(resources)
			self._list_reload()
		else:
			if value and value[0]:
				resources = value
				for r in resources:
					for k in r.keys():
						if r[k]=='':
							r[k] = False
					self.tree_view.add_line(r, modification=True)
		return True

	def _value_get(self):
		res = []
		for id in self._history:
			res.append( (2, id, False) )
		for row in self.tree_view.get_modified_rows():
			val = self.tree_view.get_row(row)
			id = val.get('id', False)
			data = copy.copy(val)
			for d in val:
				if (not d in self.fields_form) and (d!='id'):
					del data[d]
			if id:
				del data['id']
				res.append( (1, id, data) )
			else:
				if 'id' in data:
					del data['id']
				res.append( (0, False, data) )
		return res

	def clear(self):
		self._value = []
		self._history = []
		self._list_reload()

	def _menu_sig_default_set(self):
		deps = []
		wid = self.parent.widgets
		for w in wid:
			if wid[w].change_default:
				deps.append((wid[w].attrs['string'], wid[w].attrs['name'], wid[w].value2, wid[w].value2))

		values = []
		for v in self.value:
			if v[0] in (0,1):
				values.append(v[2])
		wid_common.field_pref_set(self.attrs['name'], self.attrs['string'], self.attrs['model'], values, deps)

	value = property(_value_get, _value_set, None, 'The content of the widget or ValueError if not valid')
	value2 = property(_value_get, _value_set, None, 'The content of the widget or ValueError if not valid')

