##############################################################################
#
# Copyright (c) 2005 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: intracom.py 1217 2005-08-25 14:37:19Z pinky $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import time, os
import netsvc, sql_db
from report.interface import report_rml
from osv.osv import osv_pools

europe = ('at', 'be', 'fr', 'lu', 'nl', 'uk', 'ie', 'dk', 'se', 'lv', 'lt', 'it', 'sp', 'pt', 'cz', 'de', 'sk', 'hu', 'cy', 'pl', 'fi', 'si', 'gr', 'mt', 'ee')

class report_custom(report_rml):
	def __init__(self, name, table, tmpl, xsl):
		report_rml.__init__(self, name, table, tmpl, xsl)

	def create(self, uid, ids, datas, context):
		print 'INTACOM'
		datas.setdefault('form', {})
		datas['form'].setdefault('init_date', time.strftime('%Y-%m-%d'))
		datas['form'].setdefault('end_date', time.strftime('%Y-%m-%d'))
		datas['form'].setdefault('title', 'IntraCom')
		datas['form']['year'] = datas['form']['init_date'][:4]
		datas['form']['quarter'] = divmod(int(datas['form']['init_date'][5:7])-1, 3)[0] + 1

		cr = sql_db.db.cursor()
		cr.execute('select id from account_invoice where date_invoice >= %s and date_invoice <= %s', (datas['form']['init_date'], datas['form']['end_date']))
		ids = [x[0] for x in cr.fetchall()]
		print 'IDS Found', ids
		me = osv_pools.get('res.users').browse(cr, uid, [uid])[0]
		invoices = osv_pools.get('account.invoice').browse(cr, uid, ids)
		new_ids = [inv.id for inv in invoices if inv.address_invoice_id.country_id.code != me.address_id.country_id.code and inv.address_invoice_id.country_id.code in europe]

		datas['model'] = 'account.invoice'
		datas['ids'] = new_ids
		del datas['id']
		print 'NEW IDS', new_ids

		return super(report_custom, self).create(uid, new_ids, datas, context)

report_custom('report.account.intracom', 'account.invoice', 'addons/account/report/intracom.xml', 'addons/account/report/intracom.xsl')

