# -*- coding: iso-8859-1 -*-
##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import time

import wizard
import netsvc

dates_form = '''<?xml version="1.0"?>
<form string="Grand-livre">
	<field name="date1"/>
	<field name="date2"/>
</form>'''

dates_fields = {
	'date1': {'string':u'Dbut de priode', 'type':'date', 'required':True},
	'date2': {'string':u'Fin de priode', 'type':'date', 'required':True},
}

def _get_value(self, uid, data):
	return {'date1':time.strftime('%Y-01-01'), 'date2':time.strftime('%Y-%m-%d')}

class wizard_report(wizard.interface):
	states = {
		'init': {
			'actions': [_get_value], 
			'result': {'type':'form', 'arch':dates_form, 'fields':dates_fields, 'state':[('report','Imprimer'), ('end','Annuler')]}
		},
		'report': {
			'actions': [],
			'result': {'type':'print', 'report':'account.grand.livre', 'state':'end'}
		}
	}
wizard_report('account.grand.livre.report')


