##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

from osv import fields,osv
from osv.orm import browse_null
import ir
import netsvc
import wizard
import report.custom
import sql_db

class report_custom(osv.osv):
	_name = 'ir.report.custom'
	_columns = {
		'name': fields.char('Report Name',size=64, required=True, translate=True),
		'model_id':fields.many2one('ir.model','Model',required=True, change_default=True),
		'type': fields.selection([('table','Tabular'),('pie','Pie Chart'),('bar','Bar Chart'),('line','Line Plot')], "Report Type",size=64, required='True'),
		'title': fields.char("Report title",size=64, required='True', translate=True),
		'print_format':  fields.selection((('A4','a4'),('A5','a5')), 'Print format', required=True),
		'print_orientation':  fields.selection((('landscape','Landscape'),('portrait','Portrait')), 'Print orientation', required=True, size=16),
		'repeat_header':  fields.boolean('Repeat Header'),
		'footer':  fields.char('Report Footer', size=64, required=True),
		'sortby':  fields.char('Sorted By', size=64),
		'fields_child0': fields.one2many('ir.report.custom.fields', 'report_id','Fields', required=True),
		'field_parent': fields.many2one('ir.model.fields','Child Field'),
		'state':  fields.selection([('unsubscribed','Unsubscribed'),('subscribed','Subscribed')],'State', size=64),
		'frequency': fields.selection([('Y','Yearly'),('M','Monthly'),('D','Daily')],'Frequency',size=64),
		'limitt' : fields.char('Limit', size=9),
		'action_id' : fields.many2one('ir.actions.actions', 'Action'),
		'menu_id' : fields.many2one('ir.ui.menu', 'Menu')
}
	_defaults = {
		'print_format': lambda *a: 'A4',
		'print_orientation': lambda *a: 'portrait',
		'total_only': lambda *a: 0,
		'state': lambda *a: 'unsubscribed',
		'type': lambda *a: 'table',
		'footer': lambda *a: 'Generated by Tiny ERP'
	}
	
	def onchange_model_id(self, cr, uid, ids, model_id):
		if not(model_id):
			return {}
		return {'domain': {'field_parent': [('model_id','=',model_id)]}}

	def unsubscribe(self, cr, uid, ids, context={}):
		res = False
		for report in self.browse(cr, uid, ids):
			if report.action_id:
				res = self.pool.get(report.model_id.model).unlink(cr, uid, [report.action_id.id])
		return res

	def subscribe(self, cr, uid, ids, context={}):
		check = self.browse(cr, uid, ids)
		check[0].fields_child0.sort(lambda x,y : x.sequence - y.sequence)
		
		#required on field0 does not seem to work( cause we use o2m_l ?)
		if not check[0].fields_child0:
			raise osv.except_osv('Invalid operation : ','Enter at least one field !')
		
		if check[0].type in ['pie', 'bar', 'line'] and check[0].field_parent:
			raise osv.except_osv('Invalid operation : ','Tree can only be used in tabular reports')
		
	
		if check[0].type == 'table' and check[0].field_parent and  check[0].fields_child0 and not check[0].fields_child0[0].groupby  :
			print  check[0].fields_child0[0].groupby
			print  check[0].fields_child0[0].name
			raise osv.except_osv('Invalid operation :','When creating tree (field child) report, data must be group by the first field')
			#Otherwise it won't build a goog tree(see level.pop in custom.py).
		if check[0].type == 'pie':
			if len(check[0].fields_child0) != 2:
				raise osv.except_osv('Invalid operation :','Pie charts need two fields')
			else:
				c_f = {}
				for i in range(2):
					c_f[i] = []
					tmp = check[0].fields_child0[i]
					for j in range(3):
						c_f[i].append((not isinstance(eval('tmp.field_child'+str(j)), browse_null) and eval('tmp.field_child'+str(j)+'.ttype'))or None)
				if not reduce(lambda x,y : x or y, map(lambda x: x in ['integer', 'float'], c_f[1])):
					raise osv.except_osv('Invalid operation : ','Second field should be figures')
				

		if check[0].type == 'bar':
			if len(check[0].fields_child0) < 2 :
				d
				raise osv.except_osv('Invalid operation : ','Bar charts need at least two fields')
			else:
				c_f = {}
				for i in range(len(check[0].fields_child0)):
					c_f[i] = []
					tmp = check[0].fields_child0[i]
					for j in range(3):
						c_f[i].append((not isinstance(eval('tmp.field_child'+str(j)), browse_null) and eval('tmp.field_child'+str(j)+'.ttype'))or None)

					if i == 0:
						pass
					else:
						if not reduce(lambda x,y : x or y, map(lambda x: x in ['integer', 'float'], c_f[i])):
							raise osv.except_osv('Invalid operation : ','Field %d should be a figure' %(i,))

		for report in self.browse(cr, uid, ids):
			name = report.name
			model = report.model_id.model

			if report.action_id.id:
				self.pool.get('ir.actions.report.xml').unlink(cr, uid, [report.action_id.id])
			res = {'report_id':report.id, 'type':'ir.actions.report.custom','model':model ,'name':name}
			id = self.pool.get('ir.actions.report.custom').create(cr, uid, res)
			m_id = report.menu_id.id
			self.custom_reload(cr, uid, [id])
			action = "ir.actions.report.custom,%d" % (id,)

			if not report.menu_id:
				ir.ir_set(cr, uid, 'action', 'client_print_multi', name, [(model, False)], action, False, True)
			else:
				ir.ir_set(cr, uid, 'action', 'tree_but_open', 'Menuitem', [('ir.ui.menu', int(m_id))], action, False, True)

		self.write(cr, uid, ids, {'state':'subscribed'},context)
		return True

	def custom_reload(self, cr, uid, ids=None):
		if not ids:
			ids = self.pool.get('ir.report.custom').search(cr, uid, [])
		for report in self.pool.get('ir.report.custom').read(cr, uid, ids, ['name','model']):
			report_custom_instance(report['name'], report['id'], report['model'])
report_custom()


class report_custom_fields(osv.osv):
	_name = 'ir.report.custom.fields'
	_columns = {
		'name': fields.char('Name', size=64, required=True),
		#'model': fields.char('Name', size=64),
		'report_id': fields.many2one('ir.report.custom', 'Report Ref'),
		#'model_id':fields.many2one('ir.model','Model',required=True),
		'field_child0': fields.many2one('ir.model.fields','field child0', required=True),
		'fc0_operande': fields.many2one('ir.model.fields','Constraint'), 
		'fc0_condition':fields.char('Condition', size = 64),
		'fc0_op':fields.selection((('>','>'),('<','<'),('==','='),('in','in'),('gety,==','(year)=')), 'Relation'),
		'field_child1':fields.many2one('ir.model.fields','field child1', domain=[('model_id','=',0)]),
		'fc1_operande': fields.many2one('ir.model.fields','Constraint', domain=[('model_id','=',0)]), 
		'fc1_condition':fields.char('condition', size = 64),
		'fc1_op':fields.selection((('>','>'),('<','<'),('==','='),('in','in'),('gety,==','(year)=')), 'Relation'),
		'field_child2':fields.many2one('ir.model.fields','field child2', domain=[('model_id','=',0)]),
		'fc2_operande': fields.many2one('ir.model.fields','Constraint', domain=[('model_id','=',0)]), 
		'fc2_condition':fields.char('condition', size = 64),
		'fc2_op':fields.selection((('>','>'),('<','<'),('==','='),('in','in'),('gety,==','(year)=')), 'Relation'),
		'field_child3':fields.many2one('ir.model.fields','field child3', domain=[('model_id','=',0)]),
		'fc3_operande': fields.many2one('ir.model.fields','Constraint', domain=[('model_id','=',0)]), 
		'fc3_condition':fields.char('condition', size = 64),
		'fc3_op':fields.selection((('>','>'),('<','<'),('==','='),('in','in'),('gety,==','(year)=')), 'Relation'),
		'alignment':  fields.selection((('left','left'),('right','right'),('center','center')), 'Alignment', required=True),
		'sequence': fields.integer('Sequence', required=True),
		'width': fields.integer('Fixed Width'),
		'operation': fields.selection((('none', 'None'),('calc_sum','Calculate Sum'),('calc_avg','Calculate Average'),('calc_count','Calculate Count'),('calc_max', 'Get Max'))),
		'groupby' : fields.boolean('Group by'),
		'bgcolor': fields.char('Background Color', size=64),
		'fontcolor': fields.char('Font color', size=64),
		'cumulate': fields.boolean('Cumulate')
	}
	_defaults = {
		'alignment': lambda *a: 'left',
		'bgcolor': lambda *a: 'white',
		'fontcolor': lambda *a: 'black',
		'operation': lambda *a: 'none',
	}
	_order = "sequence"

	def onchange_field_child0(self, cr, uid, ids, field_id):
		if not(field_id):
			return {}
		field = self.pool.get('ir.model.fields').browse(cr, uid, field_id)
		res = self.pool.get(field[0].model).fields_get(cr, uid, field[0].name)
		if res[field[0].name].has_key('relation'):
			cr.execute('select id from ir_model where model=%s',(res[field[0].name]['relation'],))
			id = cr.dictfetchall()
			if id:
				return {'domain': {'field_child1': [('model_id','=',id and id[0]['id'])], 'fc1_operande' : [('model_id','=',id and id[0]['id'])]}, 'required': {'field_child1': True}}
			else:
				return {'domain': {'required': {'field_child1': True}}}
		else:
			return {'domain': {'field_child1': [('model_id','=',0)]}}

	def onchange_field_child1(self, cr, uid, ids, field_id):
		if not(field_id):
			return {}
		field = self.pool.get('ir.model.fields').browse(cr, uid, field_id)
		res = self.pool.get(field[0].model).fields_get(cr, uid, field[0].name)
		if res[field[0].name].has_key('relation'):
			cr.execute('select id from ir_model where model=%s',(res[field[0].name]['relation'],))
			id = cr.dictfetchall()
			return {'domain': {'field_child2': [('model_id','=',id and id[0]['id'])],  'fc2_operande' : [('model_id','=',id and id[0]['id'])]}, 'required': {'field_child2': True}}
		else:
			return {'domain': {'field_child2': [('model_id','=',0)]}}
			
	def onchange_field_child2(self, cr, uid, ids, field_id):
		if not(field_id):
			return {}
		field = self.pool.get('ir.model.fields').browse(cr, uid, field_id)
		res = self.pool.get(field[0].model).fields_get(cr, uid, field[0].name)
		if res[field[0].name].has_key('relation'):
		 	cr.execute('select id from ir_model where model=%s',(res[field[0].name]['relation'],))
		 	id = cr.dictfetchall()
		 	return {'domain': {'field_child3': [('model_id','=',id[0]['id'])],  'fc2_operande' : [('model_id','=',id[0]['id'])]}, 'required': {'field_child3': True}}
		else:
			return {'domain': {'field_child3': [('model_id','=',0)]}}
report_custom_fields()



