##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: partner.py 1007 2005-07-25 13:18:09Z kayhman $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import pickle

from osv import fields,osv
import tools
import ir

class res_partner_function(osv.osv):
	_name = 'res.partner.function'
	_columns = {
		'name': fields.char('Name', size=64),
		'code': fields.char('Code', size=8),
	}
	_order = 'name'
res_partner_function()

class res_country(osv.osv):
	_name = 'res.country'
	_columns = {
		'name': fields.char('Country Name', size=64),
		'code': fields.char('Country Code', size=2),
	}
	def name_search(self, cr, user, name, args=[], operator='ilike', context={}):
		ids = self.search(cr, user, [('code','=',name)]+ args)
		if not ids:
			ids = self.search(cr, user, [('name',operator,name)]+ args)
		return self.name_get(cr, user, ids)
res_country()

class res_country_state(osv.osv):
	_description="The country state"
	_name = 'res.country.state'
	_columns = {
		'country_id': fields.many2one('res.country', 'Country'),
		'name': fields.char('State Name', size=64),
		'code': fields.char('State Code', size=2),
	}
	_order = 'code'
res_country_state()

class res_payterm(osv.osv):
	_description = 'The partner payment term'
	_name = 'res.payterm'
	_columns = {
		'name': fields.char('Payment term (short name)', size=64),
	}
res_payterm()

class res_partner_category_type(osv.osv):
	_description='Partner category types'
	_name = 'res.partner.category.type'
	_columns = {
		'name': fields.char('Category Name', required=True, size=64),
	}
	_order = 'name'
res_partner_category_type()

def _cat_type_get(self, cr, user):
	cr.execute('select name, name from res_partner_category_type')
	return cr.fetchall()

class res_partner_category(osv.osv):
	def name_get(self, cr, uid, ids, context={}):
		if not len(ids):
			return []
		reads = self.read(cr, uid, ids, ['name','parent_id'], context)
		res = []
		for record in reads:
			name = record['name']
			if record['parent_id']:
				name = record['parent_id'][1]+' / '+name
			res.append((record['id'], name))
		return res

	def _name_get_fnc(self, cr, uid, ids, prop, unknow_none, unknow_dict):
		res = self.name_get(cr, uid, ids)
		return dict(res)

	_description='Partner Categories'
	_name = 'res.partner.category'
	_columns = {
		'name': fields.char('Category Name', required=True, size=64),
		'type_id': fields.many2one('res.partner.category.type', 'Category Type'),
		'parent_id': fields.many2one('res.partner.category', 'Parent Category'),
		'complete_name': fields.function(_name_get_fnc, method=True, type="string", string='Name'),
		'child_ids': fields.one2many('res.partner.category', 'parent_id', 'Childs Category'),
		'active' : fields.boolean('Active'),
	}
	_defaults = {
		'active' : lambda *a: 1,
	}
	_order = 'parent_id,name'
res_partner_category()

class res_partner_title(osv.osv):
	_name = 'res.partner.title'
	_columns = {
		'name': fields.char('Title', required=True, size=24, translate=True),
		'shortcut': fields.char('Shortcut', required=True, size=24),
		'domain': fields.selection([('partner','Partner'),('contact','Contact')], 'Domain', required=True, size=24)
	}
	_order = 'name'
res_partner_title()

def _title_get2(self, cr, user):
	cr.execute('select name, name from res_partner_title where domain=%s', ('contact',))
	return cr.fetchall()

def _title_get(self, cr, user):
	cr.execute('select name, name from res_partner_title where domain=%s', ('partner',))
	return cr.fetchall()

def _lang_get(self, cr, user):
	cr.execute('select code, name from res_lang order by name')
	return cr.fetchall()+[(False, '/')]

class res_partner(osv.osv):
	_description='The partner object'
	
	def _credit_get(self, cr, uid, ids, prop, unknow_none, unknow_dict):
		res={}
#		try:
#			for id in ids:
#				acc = ir.ir_get(cr, uid, 'meta', 'account.receivable', [('res.partner',id)])[0][2]
#				cr.execute('select sum(credit) from account_move_line where account_id=%d and partner_id=%d and reconcile_id is null', (acc, id))
#				res[id]=cr.fetchone()[0] or 0.0
#		except:
		for id in ids:
			res[id]=0.0
		return res

	def _debit_get(self, cr, uid, ids, prop, unknow_none, unknow_dict):
		res={}
#		try:
#			for id in ids:
#				acc = ir.ir_get(cr, uid, 'meta', 'account.payable', [('res.partner',id)])[0][2]
#				cr.execute('select sum(debit) from account_move_line where account_id=%d and partner_id=%d and reconcile_id is null', (acc, id))
#				res[id]=cr.fetchone()[0] or 0.0
#		except:
		for id in ids:
			res[id]=0.0
		return res

	def _credit_search(self, cr, uid, obj, name, args):
		if not len(args):
			return []
		where = ' and '.join(map(lambda x: '(sum(credit)'+x[1]+str(x[2])+')',args))
		cr.execute('select partner_id from account_move_line where account_id in (select id from account_account where type=%s) and reconcile_id is null group by partner_id having '+where, ('receivable',) )
		res = cr.fetchall()
		if not len(res):
			return [('id','=','0')]
		return [('id','in',map(lambda x:x[0], res))]

	def _debit_search(self, cr, uid, obj, name, args):
		if not len(args):
			return []
		where = ' and '.join(map(lambda x: '(sum(debit)'+x[1]+str(x[2])+')',args))
		cr.execute('select partner_id from account_move_line where account_id in (select id from account_account where type=%s) and reconcile_id is null group by partner_id having '+where, ('payable',) )
		res = cr.fetchall()
		if not len(res):
			return [('id','=','0')]
		return [('id','in',map(lambda x:x[0], res))]

	_name = "res.partner"
	_order = "name"
	_columns = {
		'name': fields.char('Name', size=64, required=True),
		'title': fields.selection(_title_get, 'Title', size=32),
		'parent_id': fields.many2one('res.partner','Main Company'),
		'commercial': fields.many2one('res.users','Commercial'),
		'child_ids': fields.one2many('res.partner', 'parent_id', 'Partner Ref.'),
		'ref': fields.char('Partner ID', size=64),
		'lang':fields.selection(_lang_get, 'Language', size=2),
		'user_id':fields.many2one('res.users', 'Users'),
		'responsible':fields.many2one('res.users', 'Users'),
		'vat':fields.char('VAT',size=32),
		'bank':fields.char('Bank account',size=64),
		'website':fields.char('Website',size=64),
		'comment':fields.text('Notes'),
		'client_lien':fields.many2one('res.partner', 'Liens'),
		'address': fields.one2many('res.partner.address', 'partner_id', 'Contacts'),
		'category_id': fields.many2many('res.partner.category', 'res_partner_category_rel', 'partner_id', 'category_id', 'Categories'),
		'events': fields.one2many('res.partner.event', 'partner_id', 'events'),
		'credit_limit': fields.float(string='Credit Limit'),
		'credit': fields.function(_credit_get, fnct_search=_credit_search, method=True, string='Credit'),
		'debit': fields.function(_debit_get, fnct_search=_debit_search, method=True, string='Debit'),
		'active': fields.boolean('Active'),
	}
	_defaults = {
		'active': lambda *a: 1,
	}
	
	def name_get(self, cr, user, ids, context={}):
		if not len(ids):
			return []
		if context.get('show_ref', False):
			rec_name = 'ref'
		else:
			rec_name = 'name'
			
		res = [(r['id'], r[rec_name]) for r in self.read(cr, user, ids, [rec_name], context)]
		return res
		
	def name_search(self, cr, user, name, args=[], operator='ilike', context={}):
		ids = self.search(cr, user, [('ref','=',name)]+ args)
		if not ids:
			ids = self.search(cr, user, [('name',operator,name)]+ args)
		return self.name_get(cr, user, ids, context)

	def _email_send(self, cr, uid, ids, email_from, subject, body, on_error=None):
		emails = self.read(cr, uid, ids, ['email'])
		for email in emails:
			if email['email']:
				tools.email_send(email_from, email['email'], subject, body, on_error)
		return True

	def email_send(self, cr, uid, ids, email_from, subject, body, on_error=''):
		while len(ids):
			self.pool.get('ir.cron').create(cr, uid, {'uid':uid, 'name':'Send Partner Emails', 'date': False, 'model': 'res.partner', 'function':'_email_send', 'args': pickle.dumps((ids[:16], email_from, subject, body, on_error))})
			ids = ids[16:]
		return True
		
	def address_get(self, cr, uid, ids, adr_pref=['default']):
		cr.execute('select type,id from res_partner_address where partner_id in ('+','.join(map(str,ids))+')')
		res = cr.fetchall()
		adr = dict(res)
		# get the id of the (first) default address if there is one, 
		# otherwise get the id of the first address in the list
		default_address = adr.get('default', res[0][1])
		result = {}
		for a in adr_pref:
			result[a] = adr.get(a, default_address)
		return result
	
	def gen_next_ref(self, cr, uid, ids):
		if len(ids) != 1:
			return True
			
		# compute the next number ref
		cr.execute("select ref from res_partner where ref is not null order by char_length(ref) desc, ref desc limit 1")
		res = cr.dictfetchall()
		ref = res and res[0]['ref'] or '0'
		try:
			nextref = int(ref)+1
		except e:
			raise osv.except_osv('Warning', "Couldn't generate the next id because some partners have an alphabetic id !")

		# update the current partner
		cr.execute("update res_partner set ref=%d where id=%d", (nextref, ids[0]))
		return True
	
res_partner()

class res_partner_address(osv.osv):
	_description ='The partner description'
	_name = 'res.partner.address'
	_columns = {
		'partner_id': fields.many2one('res.partner', 'Partner', required=True, ondelete='cascade'),
		'type': fields.selection( [ ('default','Default'),('invoice','Invoice'), ('delivery','Delivery'), ('contact','Contact'), ('other','Other') ],'Address Type'),
		'function': fields.many2one('res.partner.function', 'Function', relate=True),
		'title': fields.selection(_title_get2, 'Title', size=32),
		'name': fields.char('Contact Name', size=64),
		'street': fields.char('Street', size=64),
		'street2': fields.char('Street2', size=64),
		'zip': fields.char('Zip', change_default=True, size=24),
		'city': fields.char('City', size=64),
		'state_id': fields.many2one("res.country.state", 'State',domain="[('country_id','=',country_id)]"),
		'country_id': fields.many2one('res.country', 'Country'),
		'email':fields.char('E-Mail',size=64),
		'phone':fields.char('Phone',size=64),
		'fax':fields.char('Fax',size=64),
		'mobile':fields.char('Mobile',size=64),
		'birthdate': fields.char('Birthdate',size=64),
	}
	_defaults = {
		'active' : lambda *a:1,
		}

	def name_get(self, cr, user, ids, context={}):
		if not len(ids):
			return []
		
		res = []
		for r in self.read(cr, user, ids, ['name','zip','city']):
			addr = str(r['name'] or '')
			if r['name'] and (r['zip'] or r['city']):
				addr += ', '
			addr += str(r['zip'] or '') + ' ' + str(r['city'] or '')
			res.append((r['id'], addr))
		return res

	def name_search(self, cr, user, name, args=[], operator='ilike', context={}):
		ids = self.search(cr, user, [('zip','=',name)] + args)
		if not ids: 
			ids = self.search(cr, user, [('city',operator,name)] + args)
		if not ids:
			ids = self.search(cr, user, [('name',operator,name)] + args)
		return self.name_get(cr, user, ids)


res_partner_address()

# vim:noexpandtab:
