##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: sale.py 1005 2005-07-25 08:41:42Z nicoe $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import time
import netsvc
from osv import fields,osv,orm
import ir
from mx import DateTime

class sale_shop(osv.osv):
	_name = "sale.shop"
	_description = "Sale Shop"
	_columns = {
		'name': fields.char('Shop name',size=64, required=True),
		'payment_default_id':fields.many2one('account.account','Default payment account',required=True),
		'payment_account_id':fields.many2many('account.account','sale_shop_account','shop_id','account_id','Payment accounts'),
		'warehouse_id':fields.many2one('stock.warehouse','Available Warehouse'),
		'pricelist_id':fields.many2one('product.pricelist', 'Pricelist'),
		'project_id':fields.many2one('account.project', 'Profit/Cost Center'),
	}
sale_shop()

def _incoterm_get(self, cr, user):
	cr.execute('select code, code||\', \'||name from stock_incoterms where active')
	return cr.fetchall()

class sale_order(osv.osv):
	_name = "sale.order"
	_description = "Sale Order"
	def _amount_untaxed(self, cr, uid, ids, prop, unknow_none,unknow_dict):
		id_set=",".join(map(str,ids))
		cr.execute("SELECT s.id,COALESCE(SUM(l.price_unit*l.product_qty),0) AS amount FROM sale_order s LEFT OUTER JOIN sale_order_line l ON (s.id=l.order_id) WHERE s.id IN ("+id_set+") GROUP BY s.id ")
		res=dict(cr.fetchall())
		return res

	def _amount_tax(self, cr, uid, ids, prop, unknow_none,unknow_dict):
		res={}
		for order in self.browse(cr, uid, ids):
			val=0.0
			for line in order.order_line:
				for tax in line.tax_id:
					for c in self.pool.get('account.tax').compute(cr, uid, [tax.id], line.price_unit, line.product_qty):
						val+=c['amount']
			res[order.id]=val
		return res

	def _amount_total(self, cr, uid, ids, prop, unknow_none,unknow_dict):
		res = {}
		untax = self._amount_untaxed(cr, uid, ids, prop, unknow_none,unknow_dict) 
		tax = self._amount_tax(cr, uid, ids, prop, unknow_none,unknow_dict)
		for id in ids:
			res[id] = untax.get(id,0) + tax.get(id,0)
		return res

	_columns = {
		'name': fields.char('Order Description',size=64, required=True),
		'shop_id':fields.many2one('sale.shop', 'Shop', required=True, readonly=True, states={'draft':[('readonly',False)]}),
		'origin': fields.char('Origin', size=64),

		'state': fields.selection([
			('draft','Draft'),
			('waiting_date','Waiting Schedule'),
			('manual','Manual in progress'),
			('progress','In progress'),
			('shipping_except','Shipping Exception'),
			('invoice_except','Invoice Exception'),
			('done','Done'),
			('cancel','Cancel')
		], 'Order State', readonly=True),

		'date_order':fields.date('Date Ordered', required=True, readonly=True, states={'draft':[('readonly',False)]}),

		'user_id':fields.many2one('res.users', 'Salesman', states={'draft':[('readonly',False)]}, relate=True),
		'partner_id':fields.many2one('res.partner', 'Partner', readonly=True, states={'draft':[('readonly',False)]}, change_default=True, relate=True),
		'partner_invoice_id':fields.many2one('res.partner.address', 'Invoice Address', readonly=True, required=True, states={'draft':[('readonly',False)]}),
		'partner_order_id':fields.many2one('res.partner.address', 'Ordering Address', readonly=True, required=True, states={'draft':[('readonly',False)]}),
		'partner_shipping_id':fields.many2one('res.partner.address', 'Shipping Address', readonly=True, required=True, states={'draft':[('readonly',False)]}),

		'incoterm': fields.selection(_incoterm_get, 'Incoterm',size=3),
		'picking_policy': fields.selection([('direct','Direct Delivery'),('one','All at once')], 'Picking Policy', required=True ),
		'payment_term': fields.selection((('no','No'), ('month','2% 10 Net 30')), 'Payment Term'),
		'order_policy': fields.selection([
			('prepaid','Pay before delivery'),
			('manual','Shipping & Manual Invoice'),
			('postpaid','Invoice after delivery'),
		], 'Shipping Policy', required=True, readonly=True, states={'draft':[('readonly',False)]}),
		'pricelist_id':fields.many2one('product.pricelist', 'Pricelist', required=True, readonly=True, states={'draft':[('readonly',False)]}),
		'project_id':fields.many2one('account.project', 'Profit/Cost Center', readonly=True, states={'draft':[('readonly',False)]}),

		'order_line': fields.one2many('sale.order.line', 'order_id', 'Order Lines', readonly=True, states={'draft':[('readonly',False)]}),
		'payment_line': fields.one2many('sale.order.payment', 'order_id', 'Order Payments', readonly=True, states={'draft':[('readonly',False)]}),

		'invoice_id': fields.many2one('account.invoice', 'Invoice', readonly=True),
		'picking_id': fields.many2one('stock.picking', 'Picking List', readonly=True),

		'shipped':fields.boolean('Delivered', readonly=True),
		'invoiced':fields.boolean('Paid (reconcilied)', readonly=True),

		'note': fields.text('Notes'),

		'amount_untaxed': fields.function(_amount_untaxed, method=True, string='Untaxed Amount'),
		'amount_tax': fields.function(_amount_tax, method=True, string='Taxes'),
		'amount_total': fields.function(_amount_total, method=True, string='Total'),
	}
	_defaults = {
		'picking_policy': lambda *a: 'direct',
		'date_order': lambda *a: time.strftime('%Y-%m-%d'),
		'order_policy': lambda *a: 'manual',
		'state': lambda *a: 'draft',
		'user_id': lambda x,y,z,context: z,
		'name': lambda self,cr,uid,context: self.pool.get('ir.sequence').get(cr, uid, 'sale.order')
	}

	# Form filling
	def onchange_shop_id(self, cr, uid, ids, shop_id):
		v={}
		if shop_id:
			shop=self.pool.get('sale.shop').browse(cr,uid,shop_id)
			v['project_id']=shop.project_id.id
			# Que faire si le client a une pricelist a lui ?
			if shop.pricelist_id.id:
				v['pricelist_id']=shop.pricelist_id.id
			v['payment_default_id']=shop.payment_default_id.id
		return {'value':v}

	def action_cancel_draft(self, cr, uid, ids, *args):
		self.write(cr, uid, ids, {'state':'draft'})
		wf_service = netsvc.LocalService("workflow")
		for inv_id in ids:
			wf_service.trg_create(uid, 'sale.order', inv_id, cr)
		return True

	def onchange_partner_id(self, cr, uid, ids, part):
		if not part:
			return {'value':{'partner_invoice_id': False, 'partner_shipping_id':False, 'partner_order_id':False}}
		addr = self.pool.get('res.partner').address_get(cr, uid, [part], ['delivery','invoice','contact'])
		pricelist=ir.ir_get(cr,uid, 'meta','product.pricelist',[('res.partner',part)])[0][2]
		return {'value':{'partner_invoice_id': addr['invoice'], 'partner_order_id':addr['contact'], 'partner_shipping_id':addr['delivery'], 'pricelist_id': pricelist}}

	def button_dummy(self, cr, uid, ids, context={}):
		return True

	# Workflow
	def action_direct_sale(self, cr, uid, ids, context={}):
		for id in ids:
			o=self.browse(cr,uid,id)
			if len(o.payment_line)==0:
				pay={'order_id':o.id,'name':o.name+':Payment', 'account_id':o.shop_id.payment_default_id.id, 'amount':o.amount_total}
				self.pool.get('sale.order.payment').create(cr,uid,pay)
			invoice_id = self.action_invoice_create(cr,uid,ids)
			shipping_id = self.action_ship_create(cr,uid,ids)
			self.write(cr, uid, [id], {'shipping_id':shipping_id, 'invoice_id':invoice_id})
			o=self.browse(cr,uid,id)
			total=0.0
			cr.execute("select id from account_journal where type=%s limit 1", ('sale',))
			journal_id = cr.fetchone()[0]
			for pay in o.payment_line:
				total+=pay.amount
				transfer={
					'name':pay.name,
					'partner_id': o.partner_id.id,
					'project_id': o.project_id.id,
					'journal_id': journal_id,
					'type': 'in_payment',
					'reference': '',
					'account_src_id': o.invoice_id.account_id.id,
					'account_dest_id': pay.account_id.id,
					'amount': pay.amount,
					'invoice_id': [(6,0,[o.invoice_id.id])],
				}
				t_id=self.pool.get('account.transfer').create(cr,uid,transfer)
				self.pool.get('account.transfer').pay_validate(cr,uid,[t_id])

			# Checker somme payment?
			# Make propertie of invoice==total
			# Checker stock?
			# Make propertie of shipping==possible
			if o.shipping_id:
				for pack in o.shipping_id.picking_id:
					wf_service = netsvc.LocalService("workflow")
					wf_service.trg_validate(uid, 'stock.picking', pack.id, 'picking_done', cr)
			wf_service = netsvc.LocalService("workflow")
			wf_service.trg_validate(uid, 'sale.order', o.id, 'pos_done', cr)
		return True

	def action_invoice_create(self, cr, uid, ids, grouped=False):
		res = False	
		factures = {}

		def make_invoice(order, lines):
			a=ir.ir_get(cr,uid,'meta','account.receivable',[('res.partner',o.partner_id.id)])[0][2]
			inv={
				'name': order.name,
				'origin': 'SO:'+str(order.id)+':'+order.name,
				'reference': "P%dSO%d"%(order.partner_id.id,order.id),
				'account_id': a,
				'partner_id': order.partner_id.id,
				'address_invoice_id': order.partner_invoice_id.id,
				'address_contact_id': order.partner_invoice_id.id,
				'invoice_line': lines,
				}
			inv_id = self.pool.get('account.invoice').create(cr, uid, inv, {'type' : 'customer_invoice'})
			return inv_id

		for o in self.browse(cr,uid,ids):
			if not o.invoice_id:
				il=[]
				for ol in o.order_line:
					place = []
					place.append( ('product.product',ol.product_id.id) )
					if ol.product_id and ol.product_id.categ_id:
						place.append( ('product.category', ol.product_id.categ_id.id) )
					a=ir.ir_get(cr,uid,'meta','account.income',place)[0][2]
					il.append( (0,False,{'name':ol.name, 'account_id':a, 'price_unit':ol.price_unit, 'quantity':ol.product_qty, 'invoice_line_tax_id':[(6,0,[x.id for x in ol.tax_id])] }) )
				factures.setdefault(o.partner_id.id, []).append((o, il))
			else:
				res = o.invoice_id.id

		for val in factures.values():
			if grouped:
				res = make_invoice(val[0][0], reduce(lambda x,y: x + y, [l for o,l in val], []))
				for o,l in val:
					self.write(cr, uid, [o.id], {'invoice_id' : res, 'state' : 'progress'})
			else:
				for order, il in val:
					res = make_invoice(order, il)
					self.write(cr, uid, [order.id], {'invoice_id' : res, 'state' : 'progress'})
		return res

	def action_cancel(self, cr, uid, ids, context={}):
		for r in self.read(cr,uid,ids,['invoice_id','picking_id']):
			if r['picking_id']:
				wf_service = netsvc.LocalService("workflow")
				wf_service.trg_validate(uid, 'stock.picking', r['picking_id'][0], 'button_cancel', cr)
		self.write(cr,uid,ids,{'state':'cancel'})
		return True

	def action_wait(self, cr, uid, ids, *args):

		for r in self.read(cr,uid,ids,['order_policy','invoice_id','name','amount_untaxed','partner_id','user_id']):

			if self.pool.get('res.partner.event.type').check(cr, uid, 'sale_open'):
				self.pool.get('res.partner.event').create(cr, uid, {'name':'Sale Order: '+r['name'], 'partner_id':r['partner_id'][0], 'date':time.strftime('%Y-%m-%d %H:%M:%S'), 'user_id':(r['user_id'] and r['user_id'][0]) or uid, 'partner_type':'customer', 'probability': 1.0, 'planned_revenue':r['amount_untaxed']})

			if (r['order_policy']=='manual') and (not r['invoice_id']):
				self.write(cr,uid,[r['id']],{'state':'manual'})
			else:
				self.write(cr,uid,[r['id']],{'state':'progress'})

	def action_ship_create(self, cr, uid, ids, *args):
		picking_id=False
		for order in self.browse(cr, uid, ids, context={}):
			loc_dest_id = ir.ir_get(cr,uid,'meta','stock.lot.customer',[('res.partner',order.partner_id.id)])[0][2]
			output_id = order.shop_id.warehouse_id.lot_output_id.id
			picking_id = self.pool.get('stock.picking').create(cr, uid, {
				'name':'SO:'+order.name,
				'origin':'SO:'+str(order.id)+':'+order.name,
				'type':'out',
				'state': 'auto',
				'move_type': order.picking_policy,
				'loc_move_id': loc_dest_id,
				'address_id': order.partner_shipping_id.id,
			})

			for line in order.order_line:
				if line.product_id and line.product_id.product_tmpl_id.type=='product':
					location_id = order.shop_id.warehouse_id.lot_stock_id.id
					move_id = self.pool.get('stock.move').create(cr, uid, {
						'name':'SO:'+order.name,
						'picking_id':picking_id,
						'product_id': line.product_id.id,
						'date_planned': line.date_planned,
						'product_qty': line.product_qty,
						'product_uom': line.product_uom.id,
						'address_id': order.partner_shipping_id.id,
						'location_id': location_id,
						'location_dest_id': output_id,
						'state': 'waiting',
					})
					proc_id = self.pool.get('mrp.procurement').create(cr, uid, {
						'name': 'SO:'+order.name,
						'date_planned': line.date_planned,
						'product_id': line.product_id.id,
						'product_qty': line.product_qty,
						'product_uom': line.product_uom.id,
						'location_id': order.shop_id.warehouse_id.lot_stock_id.id,
						'procure_method': line.type,
						'move_id': move_id, 
					})
					wf_service = netsvc.LocalService("workflow")
					wf_service.trg_validate(uid, 'mrp.procurement', proc_id, 'button_confirm', cr)
			wf_service = netsvc.LocalService("workflow")
			wf_service.trg_validate(uid, 'stock.picking', picking_id, 'button_confirm', cr)
			val = {'picking_id':picking_id}
			if order.state=='shipping_except':
				val['state']='progress'
				if (order.order_policy=='manual') and order.invoice_id:
					val['state']='manual'
			self.write(cr, uid, [order.id], val)
		return picking_id

	def action_ship_end(self, cr, uid, ids, context={}):
		for order in self.browse(cr, uid, ids):
			val={'shipped':True}
			if order.state=='shipping_except':
				if (order.order_policy=='manual') and not order.invoice_id:
					val['state']='manual'
				else:
					val['state'] = 'progress'
			self.write(cr, uid, [order.id], val)
		return True

	def _log_event(self, cr, uid, ids, factor=0.7, name='Open Order'):
		invs = self.read(cr, uid, ids, ['date_order','partner_id','amount_untaxed'])
		for inv in invs:
			part=inv['partner_id'] and inv['partner_id'][0]
			pr = inv['amount_untaxed'] or 0.0
			partnertype = 'customer'
			eventtype = 'sale'
			self.pool.get('res.partner.event').create(cr, uid, {'name':'Order: '+name, 'som':False, 'description':'Order '+str(inv['id']), 'document':'', 'partner_id':part, 'date':time.strftime('%Y-%m-%d'), 'canal_id':False, 'user_id':uid, 'partner_type':partnertype, 'probability':1.0, 'planned_revenue':pr, 'planned_cost':0.0, 'type':eventtype})

	def has_stockable_products(self,cr, uid, ids, *args):
		for order in self.browse(cr, uid, ids):
			for order_line in order.order_line:
				if order_line.product_id and order_line.product_id.product_tmpl_id.type=='product':
					return True
		return False
sale_order()

class sale_order_line(osv.osv):
	def _amount_line(self, cr, uid, ids, prop, unknow_none,unknow_dict):
		res = {}
		for line in self.browse(cr, uid, ids):
			res[line.id] = line.price_unit * line.product_qty
		return res

	_name = 'sale.order.line'
	_description = 'Sale Order line'
	_columns = {
		'order_id': fields.many2one('sale.order', 'Order Ref'),
		'name': fields.char('Description', size=64, required=True),
		'sequence': fields.integer('Sequence'),
		'product_qty': fields.float('Quantity', digits=(16,2), required=True),
		'date_planned': fields.date('Date Promised', required=True),
		'product_id': fields.many2one('product.product', 'Product', domain=[('sale_ok','=',True)], change_default=True),
		'procurement_id': fields.many2one('mrp.procurement', 'Procurement'),
		'product_uom': fields.many2one('product.uom', 'Unit of Measure', required=True),
		'price_unit': fields.float('Unit Price', required=True),
		'price_subtotal': fields.function(_amount_line, method=True, string='Subtotal'),
		'tax_id': fields.many2many('account.tax', 'sale_order_tax', 'order_line_id', 'tax_id', 'Taxes'),
		'type': fields.selection([('make_to_stock','from stock'),('make_to_order','on order')],'Procure Method', required=True),
		'property_ids': fields.many2many('mrp.property', 'sale_order_line_property_rel', 'order_id', 'property_id', 'Properties'),
		'notes': fields.text('Notes'),
	}
	_order = 'sequence'
	_defaults = {
		'date_planned': lambda *a: time.strftime('%Y-%m-%d'),
		'product_qty': lambda *a: 1.0,
		'sequence': lambda *a: 10,
		'price_unit': lambda *a: 1,
		'type': lambda *a: 'make_to_stock',
	}
	def product_id_change(self, cr, uid, ids, pricelist, product, qty, uom=False):
		if not pricelist:
			raise osv.except_osv('No Pricelist !', 'You have to select a pricelist in the sale form !\nPlease set one before choosing a product.')
		if not product:
			return {'value': {'price_unit': 0.0, 'name':'', 'notes':''}, 'domain':{'product_uom':[]}}
		price = self.pool.get('product.pricelist').price_get(cr,uid,[pricelist], product, qty or 1.0, 'list')[pricelist]
		if not price:
			raise osv.except_osv('Product not sellable !', 'You can not sell this product !\nYou have to change either the product, the quantity or the pricelist.')
		res = self.pool.get('product.product').read(cr, uid, [product], ['taxes_id','name','procure_method','uom_id','sale_delay','code', 'description_sale'])[0]
		dt = (DateTime.now() + DateTime.RelativeDateTime(days=res['sale_delay'] or 0.0)).strftime('%Y-%m-%d')
		result = {'price_unit': price, 'name':res['name'], 'tax_id':res['taxes_id'], 'type':res['procure_method'], 'date_planned':dt, 'notes':res['description_sale']}
		if res['code']:
			result['name'] = res['code']+', '+(result['name'] or '')
		domain = {}
		if not uom:
			result['product_uom'] = res['uom_id'] and res['uom_id'][0]
			if result['product_uom']:
				res2 = self.pool.get('product.uom').read(cr, uid, [result['product_uom']], ['category_id'])
				if res2 and res2[0]['category_id']:
					domain = {'product_uom':[('category_id','=',res2[0]['category_id'][0])]}
		return {'value':result, 'domain':domain}
sale_order_line()

class sale_payment_line(osv.osv):
	_name = 'sale.order.payment'
	_description = 'Sale Order payment'
	_columns = {
		'order_id': fields.many2one('sale.order', 'Order Ref'),
		'name': fields.char('Description', size=64, required=True),
		'account_id': fields.many2one('account.account', 'Account'),
		'amount': fields.float('Amount', required=True),
	}
	_defaults = {
	}
sale_payment_line()

