##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import wkf_logs
import workitem
import instance

import netsvc
import sql_db

class workflow_service(netsvc.Service):
	def __init__(self, name='workflow', audience='*'):
		netsvc.Service.__init__(self, name, audience)
		self.exportMethod(self.trg_write)
		self.exportMethod(self.trg_delete)
		self.exportMethod(self.trg_create)
		self.exportMethod(self.trg_validate)

	def trg_write(self, uid, res_type, res_id, cr):
		ident = (uid,res_type,res_id)
		cr.execute('select id from wkf_instance where res_id=%d and res_type=%s and state=%s', (res_id,res_type, 'active'))
		for (id,) in cr.fetchall():
			instance.update(cr, id, ident)
		cr.execute('select instance_id from wkf_triggers where res_id=%d and model=%s', (res_id,res_type))
		res = cr.fetchall()
		cr.execute('delete from wkf_triggers where model=%s and res_id=%d', (res_type,res_id))
		for (instance_id,) in res:
			cr.execute('select uid,res_type,res_id from wkf_instance where id=%d', (instance_id,))
			ident = cr.fetchone()
			instance.update(cr, instance_id, ident)

	def trg_delete(self, uid, res_type, res_id, cr):
		ident = (uid,res_type,res_id)
		instance.delete(cr, ident)
	
	def trg_create(self, uid, res_type, res_id, cr):
		ident = (uid,res_type,res_id)
		cr.execute('select id from wkf where osv=%s and on_create=True', (res_type,))
		for (wkf_id,) in cr.fetchall():
			instance.create(cr, ident, wkf_id)

	def trg_validate(self, uid, res_type, res_id, name, cr):
		ident = (uid,res_type,res_id)
		cr.execute('select id from wkf_instance where res_id=%d and res_type=%s and state=%s', (res_id,res_type, 'active'))
		for (id,) in cr.fetchall():
			instance.validate(cr, id, ident, name)

workflow_service()
