/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TTCONFIGFILE_H
#define TTCONFIGFILE_H

#include "LEntry.H"
#include "Contest.H"
#include <wx/wx.h>
#include <wx/config.h>
#include <vector>

/* a return type for the already stored courses
 * needed to hide configuration file specific knowledge
 */
class KursName {
public:
  KursName(wxString name, wxString key) : name(name),key(key) {};
  wxString name;
  wxString key;
};

/* Trying to implement this as singleton
 * This means that you can only get a pointer to it
 * by calling the static function getPtr()
 */
class TtConfigFile {
public:
  static TtConfigFile* getPtr();

  bool getBellStatus();
  void toggleBellStatus();

  wxFont* getMainWindowFont ();
  void setMainWindowFont (wxFont& storeFont);
  wxSize getMainWindowSize ();
  void setMainWindowSize (wxSize size);
  wxPoint getMainWindowPosition ();
  void setMainWindowPosition (wxPoint pos);

  int getSashPosition (int defaultPos);
  void setSashPosition (int pos);

  wxString* getKeyboardLayout ();
  void setKeyboardLayout (wxString& layout);

  wxString* getLanguage ();
  void setLanguage (wxString& lang);

  int getKursNummer (wxString& name, wxString& key);
  void storeKursNummer (wxString& name, wxString& key,
			int kursNummer);

  std::vector<LEntry>* loadKursDaten (wxString& name,
				      wxString& key);
  void storeKursDaten (wxString& name, wxString& key,
		       std::vector<LEntry>& entries);
  
  std::vector<KursName>* getKursList ();

  LEntry* loadLessonData (int index);
  void storeLessonData (int index, LEntry& entry);

  bool contestsExist();
  std::vector<ContestDesc>* getContests();
  ContestDesc getContest (long id);
  void setContest(ContestDesc& data);
  void deleteContest(long id);
  long getSelectedContestId ();
  void setSelectedContestId (long id);

  
protected:
  TtConfigFile ();
  ~TtConfigFile ();

private:
  static TtConfigFile* ptr;
  wxConfigBase* pConfig;
};

#endif
