/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTESTRANKINGDLG_H
#define CONTESTRANKINGDLG_H

#include "LEntry.H"
#include <wx/wx.h>
#include <wx/filename.h>
#include <wx/listctrl.h>

class ContestEntry {
public:
  ContestEntry (double weight) : weight(weight) {};
  wxString name;
  LEntry entry;

  static double promilleMin;
  static double apmMax;

  double getWeight() const { return this->weight; };

private:
  double weight;
};
bool operator< (const ContestEntry& a, const ContestEntry& b);

class ContestRankingDlg : public wxDialog {
public:
  ContestRankingDlg(wxWindow* parent, const wxString& title,
		    const wxFileName& dataFile, const double weight);

private:
  wxListCtrl* getListingControl (const wxFileName& dataFile, const double weight);
};

#endif
