/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ContestWizard.H"
#include "KursBeginWizard.H" //need a wizard page from there

ContestWizard::ContestWizard(wxWindow* parent, const wxString& title,
			     const wxFileName& picture, const wxString& text)
  : wxWizard(parent, -1, _T(""),
	     wxBitmap(picture.GetFullPath(),wxBITMAP_TYPE_ANY), wxDefaultPosition)
{
  SetTitle(_("Tipptrainer contest: ")+title);
  this->p1 = new wxWizardPageSimple(this);
  wxString t(text);
  t.Replace(_T("\t"),_T("   ")); //replacing tabs with 4 spaces
  this->p1text = new wxStaticText(this->p1,-1,t);
  this->p2 = new FullNameEnterPage(this);

  wxWizardPageSimple::Chain(this->p1, this->p2);
  FitToPage(p1);
}

ContestWizard::~ContestWizard () {
  delete p1text;
  delete p1;
  delete p2;
}

bool ContestWizard::runWizard () {
  return RunWizard(this->p1);
}

wxString ContestWizard::getName () {
  return this->p2->GetName();
}

BEGIN_EVENT_TABLE(FullNameEnterPage,wxWizardPageSimple)
  EVT_WIZARD_PAGE_CHANGING(wxID_ANY,FullNameEnterPage::OnPageChanging)
END_EVENT_TABLE()

FullNameEnterPage::FullNameEnterPage(wxWizard *parent)
  : wxWizardPageSimple(parent)
{
  wxStaticText* text = new wxStaticText(this,-1,_("Please enter your name:"));

  wxStaticText* ftext = new wxStaticText(this,-1,_("first name:"));
  this->ftctrl = new wxTextCtrl(this, -1);
  wxStaticText* ltext = new wxStaticText(this,-1,_("last name:"));
  this->ltctrl = new wxTextCtrl(this, -1);

  wxFlexGridSizer* subSizer = new wxFlexGridSizer(2,2,10,10);
  subSizer->AddGrowableCol(1);
  subSizer->Add(ftext,0,wxALIGN_CENTRE_VERTICAL);
  subSizer->Add(ftctrl,0,wxEXPAND);
  subSizer->Add(ltext,0,wxALIGN_CENTRE_VERTICAL);
  subSizer->Add(ltctrl,0,wxEXPAND);

  wxBoxSizer* pageSizer = new wxBoxSizer(wxVERTICAL);
  pageSizer->Add(text,0,wxBOTTOM,5);
  pageSizer->Add(subSizer,0,wxEXPAND);

  wxBoxSizer* s = new wxBoxSizer(wxHORIZONTAL);
  s->Add(pageSizer,1,wxALIGN_CENTER);
  SetSizer(s);
}

wxString FullNameEnterPage::GetName () {
  wxString s;
  s << this->firstname
    << _T(" ")
    << this->lastname;
  s.Replace(_T("\""),_T(""));
  return s;
}

void FullNameEnterPage::OnPageChanging (wxWizardEvent& e) {
  if (e.GetDirection() == true) {
    if (this->ftctrl->GetValue() == _T("") ||
	this->ltctrl->GetValue() == _T("")) {
      wxMessageBox(_("Your have to enter a name!"),
		   _("Important"), wxICON_WARNING | wxOK, this);
      e.Veto();
    } else {
      this->firstname = this->ftctrl->GetValue();
      this->firstname.Trim(true);
      this->firstname.Trim(false);
      this->lastname = this->ltctrl->GetValue();
      this->lastname.Trim(true);
      this->lastname.Trim(false);
      return;
    }
  } else {
    return;
  }
}
