/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "KursBeginWizard.H"
#include <wx/wfstream.h>
#include <wx/txtstrm.h>


#ifndef __MSW
#include "wizlogo2.xpm"
#define BMP_WIZARD_1 wxBitmap(wizlogo2_xpm);
#endif 

KursBeginWizard::KursBeginWizard (wxWindow* parent)
  : wxWizard(parent, -1, _("Start a new class"),
	     wizlogo2_xpm, wxDefaultPosition) {

  // Seite 1 des Wizards erzeugen und mit Items fllen
  this->p1 = new KursWaehlenSeite(this);
  // Seite 2 des Wizards erzeugen
  this->p2 = new NameEingebenSeite(this);
  // Seite 3 erzeugen
  this->p3 = new wxWizardPageSimple(this);
  this->p3text = new wxStaticText(p3,-1,_("Now, we have all the needed information.\nPlease press \"Finish\" to start the class\nwith the first lesson."));

  // Reihenfolge der Seiten festlegen
  wxWizardPageSimple::Chain(this->p1, this->p2);
  wxWizardPageSimple::Chain(this->p2, this->p3);
  FitToPage(p1);
}

KursBeginWizard::~KursBeginWizard () {
  delete p1;
  delete p2;
  delete p3;
}

bool KursBeginWizard::runWizard () {
  return RunWizard(this->p1);
}

int KursBeginWizard::getKursNummer () {
  return this->p1->GetSelection()+1;
}

wxString KursBeginWizard::getName () {
  return this->p2->GetName();
}

BEGIN_EVENT_TABLE(KursWaehlenSeite,wxWizardPageSimple)
  EVT_WIZARD_PAGE_CHANGING(wxID_ANY,KursWaehlenSeite::OnPageChanging)
  EVT_WIZARD_PAGE_CHANGED(wxID_ANY,KursWaehlenSeite::OnPageEnter)
END_EVENT_TABLE()

KursWaehlenSeite::KursWaehlenSeite (wxWizard *parent)
  : wxWizardPageSimple(parent) {
  // Kursinformationen auslesen
  wxString* tlayout = TtConfigFile::getPtr()->getKeyboardLayout();
  LessonDir filename;
  filename.AppendDir(*tlayout);
  filename.SetFullName(_T("kurs.index"));
  delete tlayout;
  
  wxFFileInputStream input(filename.GetFullPath());
  if (!input.Ok()) {
    ::wxLogError(_("Cannot load file %s"), filename.GetFullName().c_str());
  } else {
    wxTextInputStream f(input);
    wxString content;
    while(!input.Eof()) {
      content=f.ReadLine();
      if (!input.Eof()) {
	ar.Add(content);
      }
    }
    //convert the wxArrayString to a wxString[]
    //they are not copied, so the wxArrayString _must_ stay valid
    choices = new wxString*[ar.GetCount()];
    for (unsigned int i=0;i<ar.GetCount();++i) {
      choices[i]=&ar[i];
    }
    this->box = new wxRadioBox (this,-1,_("Please select a class"),
				wxDefaultPosition, wxDefaultSize,
				ar.GetCount(), *choices);
    //all this is done to make a nice layout
    //wxwindows documentation is totally unclear about some of those things
    //obviously: '1' (2nd param) expands to the direction of sizer
    //           'wxEXPAND' (3rd param) expands orthogonal to the direction of sizer
    wxBoxSizer* pageSizer = new wxBoxSizer(wxVERTICAL);
    //add the box and expand it horizontal
    pageSizer->Add(box,0,wxEXPAND|wxALIGN_CENTER);
    wxBoxSizer* s = new wxBoxSizer(wxHORIZONTAL);
    //add the sizer around the box and expand it horizontal, too
    s->Add(pageSizer,1,wxALIGN_CENTER);
    SetSizer(s);
  }
}

KursWaehlenSeite::~KursWaehlenSeite () {
  delete this->box;
}

void KursWaehlenSeite::OnPageChanging (wxWizardEvent& e) {
  if (e.GetDirection() == true) {
    if (this->box->GetSelection() == -1) {
      wxMessageBox(_("You have to select a class!"),
		   _("Important!"), wxICON_WARNING | wxOK, this);
      e.Veto();
    } else {
      this->selection = this->box->GetSelection();
    }
  }
  return;
}

void KursWaehlenSeite::OnPageEnter (wxWizardEvent& WXUNUSED(e)) {
  this->box->SetFocus();
}

BEGIN_EVENT_TABLE(NameEingebenSeite,wxWizardPageSimple)
  EVT_WIZARD_PAGE_CHANGING(wxID_ANY,NameEingebenSeite::OnPageChanging)
  EVT_WIZARD_PAGE_CHANGED(wxID_ANY,NameEingebenSeite::OnPageEnter)
END_EVENT_TABLE()

NameEingebenSeite::NameEingebenSeite(wxWizard *parent)
  : wxWizardPageSimple(parent) {
  this->text = new wxStaticText(this, -1,
				_("Please enter your name:"));
  this->tctrl = new wxTextCtrl(this, -1, ::wxGetUserId());
  //for sizer comments, see above
  wxBoxSizer* pageSizer = new wxBoxSizer(wxVERTICAL);
  pageSizer->Add(text,0,wxBOTTOM,5);
  pageSizer->Add(tctrl,0,wxEXPAND);
  wxBoxSizer* s = new wxBoxSizer(wxHORIZONTAL);
  s->Add(pageSizer,1,wxALIGN_CENTER);
  SetSizer(s);
}

NameEingebenSeite::~NameEingebenSeite () {
}

void NameEingebenSeite::OnPageChanging (wxWizardEvent& e) {
  if (e.GetDirection() == true) {
    if (this->tctrl->GetValue() == _T("")) {
      wxMessageBox(_("Your have to enter a name!"),
		   _("Important"), wxICON_WARNING | wxOK, this);
      e.Veto();
    } else {
      this->name = this->tctrl->GetValue();
    }
  }
  return;
}

void NameEingebenSeite::OnPageEnter (wxWizardEvent& WXUNUSED(e)) {
  this->tctrl->SetFocus();
}
