/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "lektion.h"
#include "main.h"
#include "lektionsauswahl.h"
#include "lektionsauswertung.h"
#include "lektionsanweisung.h"
#include "ConfigFile.H"
#include "LEntry.H"

BEGIN_EVENT_TABLE(Lektion,LessonController)
  LESSON_START(wxID_ANY, Lektion::onLessonStart)
  LESSON_ABORT(wxID_ANY, Lektion::onLessonAbort)
  LESSON_FINISH(wxID_ANY, Lektion::onLessonFinish)
  EVT_TIMER(wxID_ANY, Lektion::onTimer)
END_EVENT_TABLE()

Lektion::Lektion(LessonController* controller, int id)
  : lessonID(id)
{
  sw.Pause();
  timer.SetOwner(this);
  if (controller == 0) {
    this->con=this;
    if (!Hauptfenster::getPtr()->setLessonController(this)) {
      throw Abbruch();
    }
    controllerName=_("lesson");
  } else {
    this->con=controller;
  }
  if (!LektionLaden()) {
    throw LessonLoadedFailed();
  }
}

Lektion::Lektion (unsigned int lesson, LessonController* controller, int id)
  : lessonID(id)
{
  sw.Pause();
  timer.SetOwner(this);
  if (controller == 0) {
    this->con=this;
    if (!Hauptfenster::getPtr()->setLessonController(this)) {
      throw Abbruch();
    }
    controllerName=_("lesson");
  } else {
    this->con=controller;
  }
  if (lesson > 0) {
    if (!LektionLaden(lesson)) {
      throw Abbruch();
    }
  } else {
    if (!LektionLaden()) {
      throw Abbruch();
    }
  }
}

Lektion::Lektion(const wxString& lessonFile, LessonController* controller, int id)
  : lessonID(id),
    m_lektion(-1)
{
  sw.Pause();
  timer.SetOwner(this);
  if (controller == 0) {
    this->con=this;
    if (!Hauptfenster::getPtr()->setLessonController(this)) {
      throw Abbruch();
    }
    controllerName=_("lesson");
  } else {
    this->con=controller;
  }
  if (!LektionLaden(lessonFile)) {
    throw Abbruch();
  }
}

Lektion::~Lektion () {
  Hauptfenster *haupt = Hauptfenster::getPtr();

  sw.Pause();
  timer.Stop();
  haupt->GetDateiMenu()->Enable(D_LPause, false);

  haupt->GetOutput()->Clear();
  haupt->GetInput()->Clear();
  haupt->SetStatusText(_("No lesson loaded"));
  haupt->SetStatusText(_T(""), 1);
  haupt->SetStatusText(_T(""), 2);
  haupt->SetStatusText(_T(""), 3);
}

/* Load lesson
 * Calls a chooser dialog first
 */
bool Lektion::LektionLaden ()
{
  Hauptfenster *haupt = Hauptfenster::getPtr();
  Lektionsauswahl la(haupt);
  la.Center();
  if (la.ShowModal()==wxID_CANCEL) {
    return false;
  } else {
    return LektionLaden(la.GetLektion());
  }
}
/* Load lesson
 */
bool Lektion::LektionLaden (unsigned int index)
{
  m_lektion = index;
  wxString* tlayout = TtConfigFile::getPtr()->getKeyboardLayout();
  LessonDir f;
  f.AppendDir(*tlayout);
  delete tlayout;
  f.SetName(_T("lektion"));
  wxString filename;
  filename << index;
  f.SetExt(filename);
  filename=f.GetFullPath();
  return LektionLaden(filename);
}
bool Lektion::LektionLaden (const wxString& lessonFile)
{
  Hauptfenster *haupt = Hauptfenster::getPtr();
  haupt->GetOutput()->Clear();
  haupt->GetInput()->Clear();
  m_return=0;
  m_pos = 0;
  m_fehler = 0;
  m_richtig = 0;
  m_falsch=false;
  m_eb = false;
  bool loaded = haupt->GetOutput()->LoadFile(lessonFile);
  if (loaded) {
    timer.Start(1000);    
    this->con->pushStartEvent(this->lessonID);
    haupt->GetInput()->SetFocus();
    sw.Start(0);
  }
  haupt->GetDateiMenu()->Enable(D_LPause, loaded);
  haupt->GetDateiMenu()->Enable(D_LektionBeenden, loaded);
  return loaded;
}

/* Eingabe(char c)
 * hier wird die eingabe geprft
 */
bool Lektion::Eingabe (char c) {
  Hauptfenster* haupt = Hauptfenster::getPtr();
  wxString s= haupt->GetOutput()->GetValue();
  char d = s.GetChar(haupt->GetOutput()->getHighlightPosition());

  //  Die nchste if Anweisung ist dazu da, das Linefeed Zeichen dann
  //  einfach zu berspringen.
  if (d==char(182)) {
    ++m_pos;
    d = s.GetChar(haupt->GetOutput()->getHighlightPosition()+1);
  }

  //  Wieso die nchste Zeile? Im d Char sind die Zeilenumbrche mit
  //  dem Wert 10 im char c sind sie 13. Daher dieser kleine Workaround.
  if (d=='\n') {
    d=WXK_RETURN;
  }
  if (c == d) {
    //position update on output control
    if ((int)d == WXK_RETURN) {
      ++m_return;
      m_pos=-1; //zero based
    }
    haupt->GetOutput()->highlightChar(m_return,++m_pos);

    wxString s2;
    // nchster Buchstabe im StatusBar
    switch(s.GetChar(haupt->GetOutput()->getHighlightPosition())) {
    case WXK_SPACE:
      s2 = _("space key");
      break;
    case '\n':
    case char(182):
      s2 = _("return key");
      break;
    default:
      s2 = s.GetChar(haupt->GetOutput()->getHighlightPosition());
      break;
    }
    haupt->SetStatusText(s2,1);

    // Zahlen  aktuallisieren
    if (m_falsch==false) {
      ++m_richtig;
    } else {
      m_falsch=false;
    }
    s2.Empty();
    s2 << this->m_fehler << _T("|") << this->m_richtig;
    haupt->SetStatusText(s2, 2);
    return true;
  } else {
    if (m_falsch==false) {
      ++m_fehler;
      m_falsch=true;
    }
    wxString s2;
    s2 << this->m_fehler << _T("|") << this->m_richtig;
    haupt->SetStatusText(s2, 2);
    return false;
  }
}


/* timer to update time counter status bar display
 */
void Lektion::Notify () {
  Hauptfenster::getPtr()->SetStatusText(GetLessonData().getZeitString(), 3);
}

/* Ich brauch ne Pause
 */
bool Lektion::Pause () {
  if (this->con->runningLesson()) {
    sw.Pause();
    wxMessageBox(_("Press \"OK\" to continue..."), 
		 _("Lesson paused"), wxOK, Hauptfenster::getPtr());
    sw.Resume();
  }
  return true;
}

/* Ende der Lektion erreicht, was passiert jetzt?
 */
bool Lektion::LektionEnde () {
  sw.Pause();
  this->con->pushFinishEvent(this->lessonID);
  return true;
}

/* Lektion abbrechen
 */
bool Lektion::LektionAbbrechen () {
  sw.Pause();
  this->con->pushAbortEvent(this->lessonID);
  return true;
}

/* Ergebnis der Lektion speichern
 */
bool Lektion::ErgebnisSpeichern () {
  LEntry temp = GetLessonData();
  temp.setLine(m_return);
  temp.setColumn(m_pos);
  if (m_lektion>0) {
    TtConfigFile::getPtr()->storeLessonData(m_lektion,temp);
  }
  return true;
}


/*  Lektionsanweisung anzeigen
 */
bool Lektion::Lektionsanweisung (int l) {
  wxString s;
  s << _("Lesson ") << l;
  LessonStartDlg la(Hauptfenster::getPtr(),
		    l, _T(""), -1, s/*,
		    wxDefaultPosition,
		    wxSize(500, 300)*/);
  la.Centre();
  la.ShowModal();
  return true;
}

/* m_richtig um eins erhhen
 */
bool Lektion::Richtig () {
  ++m_richtig;
  return true;
}

void Lektion::onLessonStart (wxCommandEvent& WXUNUSED(e)) {
  LessonController::lesson=this;
  Lektionsanweisung(m_lektion);
}
void Lektion::onLessonAbort (wxCommandEvent& WXUNUSED(e)) {
  lauswertung laus(Hauptfenster::getPtr(), _("Lesson statistics"), this);
  laus.ShowModal();
  LessonController::lesson=0;
}
void Lektion::onLessonFinish (wxCommandEvent& WXUNUSED(e)) {
  LessonController::lesson=0;
  ErgebnisSpeichern();
  lauswertung laus(Hauptfenster::getPtr(), _("Lesson statistics"), this);
  laus.ShowModal();
  if (!LektionLaden()) {
      LessonController::lesson=0;
      Hauptfenster::getPtr()->setLessonController(0);
  }
}

void Lektion::onTimer(wxTimerEvent& WXUNUSED(e)) {
  Notify();
}
