/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "lektionsauswahl.h"
#include "ConfigFile.H"
#include "commonElements.H"
#include <wx/config.h>
#include <wx/wfstream.h>
#include <wx/txtstrm.h>
#include <wx/statline.h>

enum { // Controls
  LB = 1,
  B1,
  NOTEBOOK
};

BEGIN_EVENT_TABLE(Lektionsauswahl, wxDialog)
  EVT_BUTTON(B1, Lektionsauswahl::OnLektionStarten)
  EVT_LISTBOX(LB, Lektionsauswahl::OnListBox)
  EVT_LISTBOX_DCLICK(LB, Lektionsauswahl::OnLektionStarten)
END_EVENT_TABLE()


Lektionsauswahl::Lektionsauswahl (wxWindow* parent)
  : wxDialog(parent, -1, _("Lesson selection"))
{
  this->notebook = new wxNotebook(this,NOTEBOOK,wxDefaultPosition,
				  wxDefaultSize,wxNB_TOP);
  this->notebook->AddPage(getIncludedLessonPage(this->notebook),
			  _("Build-in lessons"), false);
  this->notebook->AddPage(getAddonLessonPage(this->notebook),
			  _("Add-on lessons"), false);
  wxNotebookSizer* nbs = new wxNotebookSizer(notebook);

  //create and add the buttons
  this->btnOk = new wxButton(this, B1, _("Start lesson"));
  this->btnCancel = new wxButton(this, wxID_CANCEL, _("Cancel"));
  wxBoxSizer* buttonSizer = new wxBoxSizer(wxHORIZONTAL);
  buttonSizer->Add(this->btnOk,1,wxEXPAND|wxALIGN_CENTER|wxRIGHT,10);
  buttonSizer->Add(this->btnCancel,1,wxEXPAND|wxALIGN_CENTER);

  wxBoxSizer* dialogSizer = new wxBoxSizer(wxVERTICAL);
  dialogSizer->Add(nbs,1,wxEXPAND);
  dialogSizer->Add(buttonSizer,0,wxALL|wxALIGN_CENTRE,10);

  SetSizer(dialogSizer);
  dialogSizer->SetSizeHints(this);
  this->btnOk->SetFocus();
}

wxPanel* Lektionsauswahl::getAddonLessonPage (wxWindow* parent) {
  wxPanel* panel = new wxPanel(parent);

  wxBoxSizer* panelSizer = new wxBoxSizer(wxHORIZONTAL);
  panelSizer->Add(getAddonLessonPageListBox(panel),
		  1,wxEXPAND|wxALL,5);
  panelSizer->Add(new wxStaticLine(panel,-1,wxDefaultPosition,wxDefaultSize,wxLI_VERTICAL),
		  0,wxEXPAND|wxALL,5);
  panelSizer->Add(common::listChangeButtons(panel),
		  0,wxEXPAND|wxALL,5);
  wxWindow::FindWindow(BTN_ADD)->Disable();
  wxWindow::FindWindow(BTN_DEL)->Disable();
  wxWindow::FindWindow(BTN_EDIT)->Disable();

  panel->SetSizer(panelSizer);
  return panel;
}

wxListBox* Lektionsauswahl::getAddonLessonPageListBox (wxWindow* parent) {
  return new wxListBox(parent,-1);
}

wxPanel* Lektionsauswahl::getIncludedLessonPage (wxWindow* parent) {
  wxPanel* panel = new wxPanel(parent);

  //listbox for the lessons
  lb = getIncludedLessonListBox(panel, LB);
  lb->SetSelection(0);

  //creating a sub sizer
  this->sb = new wxStaticBox(panel, -1, _("Lesson status"));
  this->st = new wxStaticText(panel, -1, _("You did not work on\nthis lesson, yet."));
  this->lss = new LessonStatusSizer(panel);

  this->sbSizer = new wxStaticBoxSizer(sb,wxVERTICAL);
  sbSizer->Add(this->st);
  sbSizer->Add(this->lss);

  //the following line requires a previously called SetSelection on lb
  wxCommandEvent* event = new wxCommandEvent(wxEVT_COMMAND_LISTBOX_SELECTED,
					     LB);
  ProcessEvent(*event);

  wxBoxSizer* lektionsSizer = new wxBoxSizer (wxHORIZONTAL);
  lektionsSizer->Add(lb,1,wxEXPAND);
  lektionsSizer->Add(new wxStaticLine(panel,-1,wxDefaultPosition,wxDefaultSize,wxLI_VERTICAL),
		     0,wxEXPAND|wxLEFT|wxRIGHT,10);
  lektionsSizer->Add(sbSizer,0,wxEXPAND);

  wxBoxSizer* panelSizer = new wxBoxSizer (wxVERTICAL);
  panelSizer->Add(lektionsSizer,0,wxALL,5);

  //final steps to the panel
  panel->SetSizer(panelSizer);
  return panel;
}

wxListBox* Lektionsauswahl::getIncludedLessonListBox (wxWindow* parent, int id) {
  //loading lessons index
  LessonDir filename;
  wxString* tlayout = TtConfigFile::getPtr()->getKeyboardLayout();
  filename.AppendDir(*tlayout);
  delete tlayout;
  filename.SetFullName(_T("lektion.index"));

  wxFFileInputStream input(filename.GetFullPath());
  if (!input.Ok()) {
    ::wxLogError(_("Cannot load file %s"), filename.GetFullName().c_str());
    EndModal(wxID_CANCEL);
  } else {
    wxTextInputStream f(input);
    wxString content;
    while(!input.Eof()) {
      content=f.ReadLine();
      if (!input.Eof()) {
	ar.Add(content);
      }
    }
    //convert the wxArrayString to a wxString[]
    //they are not copied, so the wxArrayString _must_ stay valid
    choices = new wxString*[ar.GetCount()];
    for (unsigned int i=0;i<ar.GetCount();++i) {
      choices[i]=&ar[i];
    }
  }
  //end loading lessons index

  return new wxListBox(parent, id, wxDefaultPosition, wxDefaultSize,
		       ar.GetCount(), *choices, wxLB_SINGLE|wxLB_NEEDED_SB);
}

Lektionsauswahl::~Lektionsauswahl () {
  delete lb;
  delete st;
  delete sb;
}

void Lektionsauswahl::OnLektionStarten (wxCommandEvent* event) {
  if (lb->GetSelection() != -1) {
    EndModal(GetReturnCode());
  } else {
    ::wxLogError(_("No lesson selected!"));
  }
}

void Lektionsauswahl::OnListBox (wxCommandEvent* event) {
  this->lastselection=lb->GetSelection();
  LEntry* entry = TtConfigFile::getPtr()->loadLessonData(this->lastselection+1);
  if (entry!=NULL) {
    sbSizer->Show(lss,true);
    sbSizer->Show(st,false);
    sbSizer->Layout();
    this->lss->setStatus(*entry);
  } else {
    sbSizer->Show(lss,false);
    sbSizer->Show(st,true);
    sbSizer->Layout();
  }
  delete entry;
}
