/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OUTPUTCONTROL_H
#define OUTPUTCONTROL_H

#include <wx/wx.h>

class TtOutputControl : public wxTextCtrl {
public:
  TtOutputControl(wxWindow *parent);
  ~TtOutputControl();

  void onSetFocus(wxFocusEvent& event);
  void onMouse(wxMouseEvent& event);

  void Clear();
  
  void setFont (wxFont& newFont);
  inline wxFont* getFont () { return localfont; };

  bool LoadFile (const wxString& filename);
  void highlightChar (long line, long column);

  long getHighlightPosition() { return this->highlightCharPos; };

private:
  wxFont* localfont;
  wxColour* textcolor;
  wxColour* bgcolor;

  long highlightCharPos;
  bool specialLineEndingChar;
  wxString fname;

  void updateLook ();

  DECLARE_EVENT_TABLE()
};

#endif
