'\"
'\" Copyright (c) 2004 Joe English
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH ttk::menubutton n 8.5 Tk "Tk Themed Widget"
.BS
.SH NAME
ttk::menubutton \- Widget that pops down a menu when pressed
.SH SYNOPSIS
\fBttk::menubutton\fR \fIpathName \fR?\fIoptions\fR?
.BE
.SH DESCRIPTION
.PP
A \fBttk::menubutton\fR widget displays a textual label and/or image,
and displays a menu when pressed.
.SO ttk_widget
\-class	\-compound	\-cursor
\-image	\-state	\-style
\-takefocus	\-text	\-textvariable
\-underline	\-width
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-direction direction Direction
Specifies where the menu is to be popped up relative 
to the menubutton.  
One of: \fBabove\fR, \fBbelow\fR, \fBleft\fR, \fBright\fR,
or \fBflush\fR.  The default is \fBbelow\fR.  
\fBflush\fR pops the menu up directly over the menubutton.
.OP \-menu menu Menu
Specifies the path name of the menu associated with the menubutton.
To be on the safe side, the menu ought to be a direct child of the
menubutton.
.\" not documented: may go away:
.\" .OP \-anchor anchor Anchor
.\" .OP \-padding padding Pad
.SH "WIDGET COMMAND"
.PP
Menubutton widgets support the standard 
\fBcget\fR, \fBconfigure\fR, \fBidentify\fR, \fBinstate\fR, and \fBstate\fR 
methods.  No other widget methods are used.
.SH "STANDARD STYLES"
.PP
\fBTtk::menubutton\fR widgets support the \fBToolbutton\fR style in all
standard themes, which is useful for creating widgets for toolbars.
.SH "SEE ALSO"
ttk::widget(n), menu(n), menubutton(n)
.SH "KEYWORDS"
widget, button, menu
'\" Local Variables:
'\" mode: nroff
'\" End:
