# $Id: idefault.tcl 1068 2007-03-27 18:47:50Z sergei $

if {$::tcl_platform(platform) == "unix" && \
	([catch {tk::pkgconfig get fontsystem} fontsystem] || \
	 ($fontsystem != "xft"))} {
    set xlfd_fonts 1
} else {
    set xlfd_fonts 0
}

if {$xlfd_fonts} {
    # We don't use named font because of insufficient flexibility of font
    # selection in Tk (for example, you can't select -slant oblique or
    # -weight semicondensed)
    # Also font encoding can't be specified
    set font "fixed"

    proc define_fonts {args} {
	global font font_bold font_italic font_bold_italic

	if {![info exists font_bold]} {
	    set font_bold [eval font create [font actual $font]]
	    font configure $font_bold -weight bold
	}
	if {![info exists font_italic]} {
	    set font_italic [eval font create [font actual $font]]
	    font configure $font_italic -slant italic
	}
	if {![info exists font_bold_italic]} {
	    set font_bold_italic [eval font create [font actual $font]]
	    font configure $font_bold_italic -weight bold -slant italic
	}
    }

    option add *Entry.font $::font widgetDefault
} else {
    switch -exact -- $::tcl_platform(platform) {
	"windows" {
	    set font [font create font -family "Arial" -size 10]
	}
	default {
	    set font [font create font -family "fixed" -size 10]
	}
    }

    set default_font [list [font actual $font -family] [font actual $font -size]]

    proc define_fonts {args} {
	global font font_bold font_italic font_bold_italic

	if {[catch {
	    set font_bold \
		[eval font create font_bold [font actual $font]]
	    set font_italic \
		[eval font create font_italic [font actual $font]]
	    set font_bold_italic \
		[eval font create font_bold_italic [font actual $font]]
	}]} {
	    eval font configure font_bold [font actual $font]
	    eval font configure font_italic [font actual $font]
	    eval font configure font_bold_italic [font actual $font]
	}
	font configure font_italic -slant italic
	font configure font_bold -weight bold
	font configure font_bold_italic -weight bold -slant italic
    }

    #font create menufont -family Helvetica -size 10 \
    # -weight normal -slant roman -underline 0 -overstrike 0
    eval [linsert [font configure $font] 0 font create menufont]

    option add *font menufont widgetDefault
    option add *Entry.font font widgetDefault
}

hook::add postload_hook [namespace current]::define_fonts 70

if {![info exists usetabbar]} {
    set usetabbar 1
}

bind Text <<ScrollUp>> {
    %W yview scroll -5 units
}
bind Text <<ScrollDown>> {
    %W yview scroll 5 units
}
bind Listbox <<ScrollUp>> {
    %W yview scroll -5 units
}
bind Listbox <<ScrollDown>> {
    %W yview scroll 5 units
}

bind Text <<ScrollLeft>> {
    %W xview scroll -10 units
}
bind Text <<ScrollRight>> {
    %W xview scroll 10 units
}
bind Listbox <<ScrollLeft>> {
    %W xview scroll -10 units
}
bind Listbox <<ScrollRight>> {
    %W xview scroll 10 units
}

if {([catch { tk windowingsystem }] && $::tcl_platform(platform) == "unix") ||
	(![catch { tk windowingsystem }] && [tk windowingsystem] == "x11")} {
    event add <<ScrollUp>>    <4>
    event add <<ScrollDown>>  <5>
    event add <<ScrollLeft>>  <Shift-4>
    event add <<ScrollRight>> <Shift-5>
}

if {$::tcl_platform(platform) == "windows"} {
    # workaround for shortcuts in russian keyboard layout
    event add <<Cut>>   <Control-division>
    event add <<Copy>>  <Control-ntilde>
    event add <<Paste>> <Control-igrave>
    event add <<Undo>>  <Control-ydiaeresis>
    event add <<Redo>>  <Control-ssharp>
    event add <<CollapseRoster>>  <Control-ecircumflex>
    event add <<OpenSearchPanel>> <Control-ucircumflex>
}

