# $Id: console.tcl 711 2006-09-12 16:34:01Z sergei $
# Add a console menu item under windows

namespace eval Console {
    variable showConsole 0
    hook::add finload_hook [namespace current]::add_console_menu
    
    proc add_console_menu {} {
        catch {
            set ndx [.menubar index [::msgcat::mc "Help"]]
            set menu [.menubar entrycget $ndx -menu]
            $menu add separator
            $menu add checkbutton -label [::msgcat::mc "Show console"] \
                -command [namespace current]::show_console \
                -variable [namespace current]::showConsole
            show_console
        }
    }
    
    proc show_console {} {
        variable showConsole
        if {$showConsole} {
            console show
        } else {
            console hide
        }
    }
}
