# $Id: register.tcl 1099 2007-04-12 06:44:00Z sergei $

namespace eval register {
    set winid 0
}

proc register::open {jid args} {
    variable winid

    foreach {key val} $args {
	switch -- $key {
	    -connection { set connid $val }
	}
    }
    if {![info exists connid]} {
	return -code error "register::open: -connection required"
    }

    set w .register$winid
    toplevel $w
    wm group $w .
    set title [format [::msgcat::mc "Register in %s"] $jid]
    wm title $w $title
    wm iconname $w $title
    wm transient $w .
    if {$::tcl_platform(platform) == "macintosh"} {
        catch { unsupported1 style $w floating sideTitlebar }
    } elseif {$::aquaP} {
        ::tk::unsupported::MacWindowStyle style $w dBoxProc
    }
    wm resizable $w 0 0

    set hf [frame $w.error]
    set vf [frame $w.vf]
    set sep [Separator::create $w.sep -orient horizontal]

    set sw [ScrolledWindow $w.sw]
    set sf [ScrollableFrame $w.fields -constrainedwidth yes]
    set f [$sf getframe]
    $sf configure -height 10
    $sw setwidget $sf

    bindscroll $f $sf

    set bbox [ButtonBox $w.bbox -spacing 0 -padx 10 -default 0]
    $bbox add -text [::msgcat::mc "Register"] \
	-command [list register::register $w $f $connid $jid] \
        -state disabled
    $bbox add -text [::msgcat::mc "Unregister"] \
	-command [list register::unregister $w $connid $jid] \
        -state disabled
    $bbox add -text [::msgcat::mc "Cancel"] -command [list destroy $w]
    bind $w <Return> "ButtonBox::invoke $bbox default"
    bind $w <Escape> "ButtonBox::invoke $bbox 2"
    pack $bbox -padx 2m -pady 2m -anchor e -side bottom

    pack $sep -side bottom -fill x -pady 1m
    pack $hf -side top
    pack $vf -side left -pady 2m
    pack $sw -side top -expand yes -fill both -padx 2m -pady 2m

    bind $f <Destroy> [list data::cleanup $f]

    wm withdraw $w

    jlib::send_iq get \
	[jlib::wrapper:createtag query \
	     -vars [list xmlns $::NS(register)]] \
	-to $jid \
	-connection $connid \
	-command [list register::recv_fields $w $f $connid $jid]
    
    incr winid
}


proc register::recv_fields {w f connid jid res child} {
    debugmsg register "$res $child"

    switch -- $res {
	ERR {
	    destroy $w
	    MessageDlg ${w}_err -aspect 50000 -icon error \
		-message [format [::msgcat::mc "Registration: %s"] \
				 [error_to_string $child]] \
		-type user -buttons ok -default 0 -cancel 0
	}
	OK {
	    jlib::wrapper:splitxml $child tag vars isempty chdata children

	    if {[jlib::wrapper:getattr $vars xmlns] == $::NS(register)} {
		set focus [data::fill_fields $f $children]
	    }

	    $w.bbox itemconfigure 0 -state normal
	    if {$jid != [jlib::connection_server $connid]} {
		$w.bbox itemconfigure 1 -state normal
	    }

	    update idletasks
	    $w.error configure -width [expr {[winfo reqwidth $f] + [winfo pixels $f 1c]}]

	    set h [winfo reqheight $f]
	    set sh [winfo screenheight $w]
	    if {$h > $sh - 200} {
		set h [expr {$sh - 200}]
	    }
	    $w.vf configure -height $h
	    wm deiconify $w

	    if {$focus != ""} {
		focus $focus
	    }
	}
	default {
	    destroy $w
	}
    }
}


proc register::register {w f connid jid} {
    variable data

    destroy $w.error.msg
    $w.bbox itemconfigure 0 -state disabled
    $w.bbox itemconfigure 1 -state disabled

    set restags [data::get_tags $f]

    jlib::send_iq set [jlib::wrapper:createtag query \
			   -vars [list xmlns $::NS(register)] \
			   -subtags $restags] \
	-to $jid \
	-connection $connid \
	-command [list register::recv_result $w $connid $jid]
}


proc register::unregister {w connid jid} {
    variable data

    destroy $w.error.msg
    $w.bbox itemconfigure 0 -state disabled
    $w.bbox itemconfigure 1 -state disabled

    jlib::send_iq set [jlib::wrapper:createtag query \
			   -vars [list xmlns $::NS(register)] \
			   -subtags [list [jlib::wrapper:createtag remove]]] \
	-to $jid \
	-connection $connid \
	-command [list register::recv_result $w $connid $jid]
}


proc register::recv_result {w connid jid res child} {
    global font
    variable data

    debugmsg register "$res $child"
    
    if {![cequal $res OK]} {
	$w.bbox itemconfigure 0 -state normal
	if {$jid != [jlib::connection_server $connid]} {
	    $w.bbox itemconfigure 1 -state normal
	}

	set m [message $w.error.msg \
		       -aspect 50000 \
		       -text [error_to_string $child] \
		       -font $font \
		       -pady 2m]
	$m configure -foreground [option get $m errorForeground Message]
	pack $m

	return
    }

    set result [::msgcat::mc "Registration is successful!"]
    label $w.result -text $result
    pack $w.result -expand yes -fill both -after $w.sw -anchor nw \
	-padx 1c -pady 1c
    pack forget $w.sw

    pack forget $w.bbox
    set bbox [ButtonBox $w.bbox1 -spacing 0 -padx 10 -default 0]
    $bbox add -text [::msgcat::mc "Close"] -command [list destroy $w]
    bind $w <Return> "ButtonBox::invoke $w.bbox1 default"
    bind $w <Escape> "ButtonBox::invoke $w.bbox1 0"
    pack $bbox -padx 2m -pady 2m -anchor e -side bottom -before $w.sep
}


hook::add postload_hook \
    [list browser::register_ns_handler $::NS(register) register::open \
    -desc [list * [::msgcat::mc "Register"]]]
hook::add postload_hook \
    [list disco::browser::register_feature_handler $::NS(register) register::open \
    -desc [list * [::msgcat::mc "Register"]]]
